/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.metadata.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesValidator;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.DuplicateResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.ResourceSegmentsConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlterResourceBackendHandler
extends DatabaseRequiredBackendHandler<AlterResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlterResourceBackendHandler.class);
    private final DatabaseType databaseType;
    private final DataSourcePropertiesValidator validator;

    public AlterResourceBackendHandler(AlterResourceStatement sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
        this.databaseType = connectionSession.getDatabaseType();
        this.validator = new DataSourcePropertiesValidator();
    }

    @Override
    public ResponseHeader execute(String databaseName, AlterResourceStatement sqlStatement) throws DistSQLException {
        this.checkSQLStatement(databaseName, sqlStatement);
        Map<String, DataSourceProperties> dataSourcePropsMap = ResourceSegmentsConverter.convert(this.databaseType, sqlStatement.getDataSources());
        this.validator.validate(dataSourcePropsMap);
        try {
            ProxyContext.getInstance().getContextManager().alterResource(databaseName, dataSourcePropsMap);
        }
        catch (Exception ex) {
            log.error("Alter resource failed", (Throwable)ex);
            throw new InvalidResourcesException(Collections.singleton(ex.getMessage()));
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void checkSQLStatement(String databaseName, AlterResourceStatement sqlStatement) throws DistSQLException {
        Collection<String> toBeAlteredResourceNames = this.getToBeAlteredResourceNames(sqlStatement);
        this.checkToBeAlteredDuplicateResourceNames(toBeAlteredResourceNames);
        this.checkResourceNameExisted(databaseName, toBeAlteredResourceNames);
        this.checkDatabase(databaseName, sqlStatement);
    }

    private void checkDatabase(String databaseName, AlterResourceStatement sqlStatement) throws DistSQLException {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResource().getDataSources();
        Collection invalid = sqlStatement.getDataSources().stream().collect(Collectors.toMap(DataSourceSegment::getName, each -> each)).entrySet().stream().filter(each -> !this.isIdenticalDatabase((DataSourceSegment)each.getValue(), (DataSource)resources.get(each.getKey()))).map(Map.Entry::getKey).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), () -> new InvalidResourcesException(Collections.singleton(String.format("Cannot alter the database of %s", invalid))));
    }

    private Collection<String> getToBeAlteredResourceNames(AlterResourceStatement sqlStatement) {
        return sqlStatement.getDataSources().stream().map(DataSourceSegment::getName).collect(Collectors.toList());
    }

    private void checkToBeAlteredDuplicateResourceNames(Collection<String> resourceNames) throws DistSQLException {
        Collection<String> duplicateResourceNames = this.getDuplicateResourceNames(resourceNames);
        DistSQLException.predictionThrow((boolean)duplicateResourceNames.isEmpty(), () -> new DuplicateResourceException(duplicateResourceNames));
    }

    private Collection<String> getDuplicateResourceNames(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> resourceNames.stream().filter(each::equals).count() > 1L).collect(Collectors.toList());
    }

    private void checkResourceNameExisted(String databaseName, Collection<String> resourceNames) throws DistSQLException {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResource().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedResourceNames.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistedResourceNames));
    }

    private boolean isIdenticalDatabase(DataSourceSegment segment, DataSource dataSource) {
        String url;
        JdbcUrl dataSourceJdbcUrl;
        String hostName = segment.getHostname();
        String port = segment.getPort();
        String database = segment.getDatabase();
        if (null != segment.getUrl() && (null == hostName || null == port || null == database)) {
            JdbcUrl segmentJdbcUrl = new StandardJdbcUrlParser().parse(segment.getUrl());
            hostName = segmentJdbcUrl.getHostname();
            port = String.valueOf(segmentJdbcUrl.getPort());
            database = segmentJdbcUrl.getDatabase();
        }
        return hostName.equals((dataSourceJdbcUrl = new StandardJdbcUrlParser().parse(url = String.valueOf(DataSourcePropertiesCreator.create((DataSource)dataSource).getConnectionPropertySynonyms().getStandardProperties().get("url")))).getHostname()) && port.equals(String.valueOf(dataSourceJdbcUrl.getPort())) && database.equals(dataSourceJdbcUrl.getDatabase());
    }
}

