/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RuleDefinitionStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.AddResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.AlterResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.DropResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule.RuleDefinitionBackendHandler;

public final class RDLBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(RDLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        return RDLBackendHandlerFactory.createBackendHandler(sqlStatement, connectionSession);
    }

    private static TextProtocolBackendHandler createBackendHandler(RDLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof AddResourceStatement) {
            return new AddResourceBackendHandler((AddResourceStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof AlterResourceStatement) {
            return new AlterResourceBackendHandler((AlterResourceStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof DropResourceStatement) {
            return new DropResourceBackendHandler((DropResourceStatement)sqlStatement, connectionSession);
        }
        return new RuleDefinitionBackendHandler<RuleDefinitionStatement>((RuleDefinitionStatement)sqlStatement, connectionSession);
    }

    @Generated
    private RDLBackendHandlerFactory() {
    }
}

