/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.scaling.query;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class QueryableScalingRALBackendHandler
extends DatabaseRequiredBackendHandler<RALStatement> {
    private final DistSQLResultSet resultSet;

    public QueryableScalingRALBackendHandler(RALStatement sqlStatement, ConnectionSession connectionSession, DistSQLResultSet resultSet) {
        super(sqlStatement, connectionSession);
        this.resultSet = resultSet;
    }

    @Override
    protected ResponseHeader execute(String databaseName, RALStatement sqlStatement) {
        this.resultSet.init(ProxyContext.getInstance().getDatabase(databaseName), (SQLStatement)sqlStatement);
        ArrayList<QueryHeader> queryHeaders = new ArrayList<QueryHeader>();
        for (String each : this.resultSet.getColumnNames()) {
            queryHeaders.add(new QueryHeader(databaseName, "", each, each, 1, "CHAR", 255, 0, false, false, false, false));
        }
        return new QueryResponseHeader(queryHeaders);
    }

    @Override
    public boolean next() {
        return this.resultSet.next();
    }

    @Override
    public Collection<Object> getRowData() {
        return this.resultSet.getRowData();
    }
}

