/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.UnlabelInstanceStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;

public final class UnlabelInstanceHandler
extends UpdatableRALBackendHandler<UnlabelInstanceStatement, UnlabelInstanceHandler> {
    @Override
    protected void update(ContextManager contextManager, UnlabelInstanceStatement sqlStatement) throws DistSQLException {
        MetaDataPersistService persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService().orElse(null);
        if (null == persistService || null == persistService.getRepository() || persistService.getRepository() instanceof StandalonePersistRepository) {
            throw new UnsupportedOperationException("Labels can only be removed in cluster mode");
        }
        String instanceId = sqlStatement.getInstanceId();
        Optional computeNodeInstance = contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            if (sqlStatement.getLabels().isEmpty()) {
                ShardingSphereEventBus.getInstance().post((Object)new LabelsChangedEvent(instanceId, (Collection)Collections.EMPTY_LIST));
            } else {
                labels.removeAll(sqlStatement.getLabels());
                ShardingSphereEventBus.getInstance().post((Object)new LabelsChangedEvent(instanceId, new LinkedList(labels)));
            }
        }
    }
}

