/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.SetVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.properties.TypedPropertyKey;
import org.apache.shardingsphere.infra.properties.TypedPropertyValue;
import org.apache.shardingsphere.infra.properties.TypedPropertyValueException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.InvalidValueException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class SetVariableHandler
extends UpdatableRALBackendHandler<SetVariableStatement, SetVariableHandler> {
    private ConnectionSession connectionSession;

    @Override
    public SetVariableHandler init(RALBackendHandler.HandlerParameter<SetVariableStatement> parameter) {
        this.initStatement(parameter.getStatement());
        this.connectionSession = parameter.getConnectionSession();
        return this;
    }

    @Override
    protected void update(ContextManager contextManager, SetVariableStatement sqlStatement) throws DistSQLException {
        Enum<?> enumType = this.getEnumType(sqlStatement.getName());
        if (enumType instanceof ConfigurationPropertyKey) {
            this.handleConfigurationProperty((ConfigurationPropertyKey)enumType, sqlStatement.getValue());
        } else if (enumType instanceof VariableEnum) {
            this.handleVariables(sqlStatement);
        } else {
            throw new UnsupportedVariableException(sqlStatement.getName());
        }
    }

    private Enum<?> getEnumType(String name) {
        try {
            return ConfigurationPropertyKey.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return VariableEnum.getValueOf(name);
        }
    }

    private void handleConfigurationProperty(ConfigurationPropertyKey propertyKey, String value) {
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        MetaDataContexts metaDataContexts = contextManager.getMetaDataContexts();
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        Properties props = new Properties(metaDataContexts.getMetaData().getProps().getProps());
        props.put(propertyKey.getKey(), this.getValue(propertyKey, value));
        contextManager.alterProperties(props);
        if (metaDataPersistService.isPresent() && null != ((MetaDataPersistService)metaDataPersistService.get()).getPropsService()) {
            ((MetaDataPersistService)metaDataPersistService.get()).getPropsService().persist(props, true);
        }
    }

    private Object getValue(ConfigurationPropertyKey propertyKey, String value) {
        try {
            TypedPropertyValue propertyValue = new TypedPropertyValue((TypedPropertyKey)propertyKey, value);
            return propertyValue.getValue();
        }
        catch (TypedPropertyValueException ex) {
            throw new InvalidValueException(value);
        }
    }

    private void handleVariables(SetVariableStatement setVariableStatement) {
        VariableEnum variable = VariableEnum.getValueOf(setVariableStatement.getName());
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                Boolean agentPluginsEnabled = BooleanUtils.toBooleanObject((String)((SetVariableStatement)this.sqlStatement).getValue());
                SystemPropertyUtil.setSystemProperty(variable.name(), null == agentPluginsEnabled ? Boolean.FALSE.toString() : agentPluginsEnabled.toString());
                break;
            }
            case TRANSACTION_TYPE: {
                this.connectionSession.getTransactionStatus().setTransactionType(this.getTransactionType(((SetVariableStatement)this.sqlStatement).getValue()));
                break;
            }
            default: {
                throw new UnsupportedVariableException(setVariableStatement.getName());
            }
        }
    }

    private TransactionType getTransactionType(String transactionTypeName) throws UnsupportedVariableException {
        try {
            return TransactionType.valueOf((String)transactionTypeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedVariableException(transactionTypeName);
        }
    }
}

