/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service.StorageNodeStatusService;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceDisabledEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.status.SetReadwriteSplittingStatusStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class SetReadwriteSplittingStatusHandler
extends UpdatableRALBackendHandler<SetReadwriteSplittingStatusStatement, SetReadwriteSplittingStatusHandler> {
    private static final String DISABLE = "DISABLE";
    private ConnectionSession connectionSession;

    @Override
    public SetReadwriteSplittingStatusHandler init(RALBackendHandler.HandlerParameter<SetReadwriteSplittingStatusStatement> parameter) {
        this.initStatement(parameter.getStatement());
        this.connectionSession = parameter.getConnectionSession();
        return this;
    }

    @Override
    protected void update(ContextManager contextManager, SetReadwriteSplittingStatusStatement sqlStatement) throws DistSQLException {
        String databaseName = sqlStatement.getDatabase().isPresent() ? ((DatabaseSegment)sqlStatement.getDatabase().get()).getIdentifier().getValue() : this.connectionSession.getDatabaseName();
        String toBeUpdatedResource = sqlStatement.getResourceName();
        this.checkModeAndPersistRepository(contextManager);
        this.checkDatabaseName(databaseName);
        this.checkReadwriteSplittingRule(contextManager, databaseName);
        Map<String, String> replicaResources = this.getReplicaResources(contextManager, databaseName);
        Map<String, String> disabledResources = this.getDisabledResources(contextManager, databaseName);
        Map<String, String> autoAwareResources = this.getAutoAwareResources(contextManager, databaseName);
        boolean isDisable = DISABLE.equals(sqlStatement.getStatus());
        if (isDisable) {
            this.checkDisable(contextManager, databaseName, disabledResources.keySet(), toBeUpdatedResource, replicaResources);
        } else {
            this.checkEnable(contextManager, databaseName, disabledResources, toBeUpdatedResource);
        }
        Collection<String> groupNames = this.getGroupNames(toBeUpdatedResource, replicaResources, disabledResources, autoAwareResources);
        this.updateStatus(databaseName, groupNames, toBeUpdatedResource, isDisable);
    }

    private ReadwriteSplittingRuleConfiguration checkReadwriteSplittingRule(ContextManager contextManager, String databaseName) {
        Optional result = ((ShardingSphereDatabase)contextManager.getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().findRuleConfigurations(ReadwriteSplittingRuleConfiguration.class).stream().findAny();
        if (!result.isPresent()) {
            throw new UnsupportedOperationException("The current schema has no read_write splitting rules");
        }
        return (ReadwriteSplittingRuleConfiguration)result.get();
    }

    private void checkModeAndPersistRepository(ContextManager contextManager) {
        if (!contextManager.getInstanceContext().isCluster()) {
            throw new UnsupportedOperationException("Mode must be `Cluster`.");
        }
        if (!contextManager.getMetaDataContexts().getPersistService().isPresent()) {
            throw new UnsupportedOperationException("Persistence must be configured");
        }
    }

    private void checkDatabaseName(String databaseName) {
        if (Strings.isNullOrEmpty((String)databaseName)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(databaseName)) {
            throw new DatabaseNotExistedException(databaseName);
        }
    }

    private Map<String, String> getReplicaResources(ContextManager contextManager, String databaseName) {
        Map<String, Map<String, String>> readwriteSplittingRules = this.getExportedReadwriteSplittingRules(contextManager, databaseName);
        HashMap<String, String> result = new HashMap<String, String>();
        readwriteSplittingRules.entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).forEach(entry -> this.addReplicaResource((Map<String, String>)result, (Map.Entry<String, Map<String, String>>)entry));
        return result;
    }

    private Map<String, String> getAutoAwareResources(ContextManager contextManager, String databaseName) {
        Map<String, Map<String, String>> readwriteSplittingRules = this.getExportedReadwriteSplittingRules(contextManager, databaseName);
        HashMap<String, String> result = new HashMap<String, String>();
        readwriteSplittingRules.values().stream().filter(each -> each.containsKey("auto_aware_data_source_name")).forEach(each -> Splitter.on((String)",").splitToList((CharSequence)each.get("replica_data_source_names")).forEach(each1 -> this.put(result, (String)each1, (String)each.get("auto_aware_data_source_name"))));
        return result;
    }

    private Map<String, String> getDisabledResources(ContextManager contextManager, String databaseName) {
        Optional persistService = contextManager.getMetaDataContexts().getPersistService();
        HashMap<String, String> result = new HashMap<String, String>();
        persistService.ifPresent(optional -> {
            Map<String, String> disableNodes = this.getDisabledStorageNodes(databaseName, (MetaDataPersistService)optional).stream().collect(Collectors.toMap(QualifiedDatabase::getDataSourceName, QualifiedDatabase::getGroupName, (value1, value2) -> String.join((CharSequence)",", value1, value2)));
            result.putAll(disableNodes);
        });
        return result;
    }

    private void checkEnable(ContextManager contextManager, String databaseName, Map<String, String> disabledResources, String toBeEnabledResource) throws DistSQLException {
        this.checkResourceExists(contextManager, databaseName, toBeEnabledResource);
        this.checkIsNotDisabled(disabledResources.keySet(), toBeEnabledResource);
    }

    private void checkResourceExists(ContextManager contextManager, String databaseName, String toBeDisabledResource) throws DistSQLException {
        Collection notExistedResources = ((ShardingSphereDatabase)contextManager.getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getResource().getNotExistedResources(Collections.singleton(toBeDisabledResource));
        DistSQLException.predictionThrow((boolean)notExistedResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, Collections.singleton(toBeDisabledResource)));
    }

    private void checkIsNotDisabled(Collection<String> disabledResources, String toBeEnabledResource) {
        if (!disabledResources.contains(toBeEnabledResource)) {
            throw new UnsupportedOperationException(String.format("`%s` is not disabled", toBeEnabledResource));
        }
    }

    private void checkDisable(ContextManager contextManager, String databaseName, Collection<String> disabledResources, String toBeDisabledResource, Map<String, String> replicaResources) throws DistSQLException {
        this.checkResourceExists(contextManager, databaseName, toBeDisabledResource);
        this.checkIsDisabled(replicaResources, disabledResources, toBeDisabledResource);
        this.checkIsReplicaResource(replicaResources, toBeDisabledResource);
        this.checkIsLastResource(replicaResources, toBeDisabledResource);
    }

    private void checkIsDisabled(Map<String, String> replicaResources, Collection<String> disabledResources, String toBeDisabledResource) {
        String toBeDisableResourceRuleNames = replicaResources.get(toBeDisabledResource);
        if (Strings.isNullOrEmpty((String)toBeDisableResourceRuleNames) && disabledResources.contains(toBeDisabledResource)) {
            throw new UnsupportedOperationException(String.format("`%s` has been disabled", toBeDisabledResource));
        }
    }

    private void checkIsReplicaResource(Map<String, String> replicaResources, String toBeDisabledResource) {
        if (!replicaResources.containsKey(toBeDisabledResource)) {
            throw new UnsupportedOperationException(String.format("`%s` is not used as a read resource by any read-write separation rules,cannot be disabled", toBeDisabledResource));
        }
    }

    private void checkIsLastResource(Map<String, String> replicaResources, String toBeDisabledResource) {
        Collection onlyOneResourceRules = this.getOnlyOneResourceRules(replicaResources);
        List toBeDisabledResourceRuleNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)replicaResources.get(toBeDisabledResource));
        if (!(onlyOneResourceRules = (Collection)onlyOneResourceRules.stream().filter(toBeDisabledResourceRuleNames::contains).collect(Collectors.toSet())).isEmpty()) {
            throw new UnsupportedOperationException(String.format("`%s` is the last read resource in `%s`, cannot be disabled", toBeDisabledResource, onlyOneResourceRules));
        }
    }

    private Collection<String> getGroupNames(String toBeDisableResource, Map<String, String> replicaResources, Map<String, String> disabledResources, Map<String, String> autoAwareResources) {
        String groupNames = autoAwareResources.getOrDefault(toBeDisableResource, replicaResources.getOrDefault(toBeDisableResource, disabledResources.get(toBeDisableResource)));
        return Splitter.on((String)",").splitToList((CharSequence)groupNames);
    }

    private void updateStatus(String databaseName, Collection<String> groupNames, String toBeDisableResource, boolean isDisable) {
        groupNames.forEach(each -> {
            StorageNodeDataSource storageNodeDataSource = new StorageNodeDataSource(StorageNodeRole.MEMBER, isDisable ? StorageNodeStatus.DISABLED : StorageNodeStatus.ENABLED);
            ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(databaseName, each, toBeDisableResource, storageNodeDataSource));
        });
    }

    private Collection<QualifiedDatabase> getDisabledStorageNodes(String databaseName, MetaDataPersistService persistService) {
        Map storageNodes = new StorageNodeStatusService((ClusterPersistRepository)persistService.getRepository()).loadStorageNodes();
        return storageNodes.entrySet().stream().filter(each -> StorageNodeStatus.DISABLED.name().equalsIgnoreCase(((StorageNodeDataSource)each.getValue()).getStatus())).map(each -> new QualifiedDatabase((String)each.getKey())).filter(each -> databaseName.equalsIgnoreCase(each.getDatabaseName())).collect(Collectors.toList());
    }

    private Map<String, Map<String, String>> getExportedReadwriteSplittingRules(ContextManager contextManager, String databaseName) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        ((ShardingSphereDatabase)contextManager.getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().findRules(ReadwriteSplittingRule.class).stream().findAny().filter(each -> each.containExportableKey(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"))).map(each -> each.export(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"))).ifPresent(optional -> {
            result.putAll(optional.getOrDefault("dynamic_readwrite_splitting_rules", Collections.emptyMap()));
            result.putAll(optional.getOrDefault("static_readwrite_splitting_rules", Collections.emptyMap()));
        });
        return result;
    }

    private Collection<String> getOnlyOneResourceRules(Map<String, String> replicaResources) {
        return replicaResources.values().stream().map(databaseName -> Arrays.stream(databaseName.split(",")).collect(Collectors.toMap(each -> each, each -> 1)).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() <= 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void addReplicaResource(Map<String, String> replicaResources, Map.Entry<String, Map<String, String>> readwriteSplittingRule) {
        readwriteSplittingRule.getValue().entrySet().stream().filter(entry -> "replica_data_source_names".equals(entry.getKey())).map(entry -> Arrays.asList(((String)entry.getValue()).split(","))).flatMap(Collection::stream).forEach(each -> this.put(replicaResources, (String)each, (String)readwriteSplittingRule.getKey()));
    }

    private void put(Map<String, String> map, String key, String value) {
        if (map.containsKey(key)) {
            map.put(key, String.join((CharSequence)",", map.get(key), value));
        } else {
            map.put(key, value);
        }
    }
}

