/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.SetInstanceStatusStatement;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.state.StateType;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ComputeNodeStatusChangedEvent;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;

public final class SetInstanceStatusHandler
extends UpdatableRALBackendHandler<SetInstanceStatusStatement, SetInstanceStatusHandler> {
    @Override
    protected void update(ContextManager contextManager, SetInstanceStatusStatement sqlStatement) {
        if (!contextManager.getInstanceContext().isCluster()) {
            throw new UnsupportedOperationException("Only allowed in cluster mode");
        }
        String instanceId = sqlStatement.getInstanceId();
        boolean isDisable = "DISABLE".equals(sqlStatement.getStatus());
        if (isDisable) {
            this.checkDisablingIsValid(contextManager, instanceId);
        } else {
            this.checkEnablingIsValid(contextManager, instanceId);
        }
        ShardingSphereEventBus.getInstance().post((Object)new ComputeNodeStatusChangedEvent(isDisable ? ComputeNodeStatus.CIRCUIT_BREAK : ComputeNodeStatus.ONLINE, instanceId));
    }

    private void checkEnablingIsValid(ContextManager contextManager, String instanceId) {
        if (!contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).isPresent()) {
            throw new UnsupportedOperationException(String.format("`%s` does not exist", instanceId));
        }
    }

    private void checkDisablingIsValid(ContextManager contextManager, String instanceId) {
        if (contextManager.getInstanceContext().getInstance().getCurrentInstanceId().equals(instanceId)) {
            throw new UnsupportedOperationException(String.format("`%s` is the currently in use instance and cannot be disabled", instanceId));
        }
        if (!contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).isPresent()) {
            throw new UnsupportedOperationException(String.format("`%s` does not exist", instanceId));
        }
        if (((ComputeNodeInstance)contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).get()).getState().getCurrentState() == StateType.CIRCUIT_BREAK) {
            throw new UnsupportedOperationException(String.format("`%s` compute node has been disabled", instanceId));
        }
    }
}

