/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import com.google.common.base.Strings;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.RefreshTableMetadataStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;

public final class RefreshTableMetadataHandler
extends UpdatableRALBackendHandler<RefreshTableMetadataStatement, RefreshTableMetadataHandler> {
    private ConnectionSession connectionSession;

    @Override
    public RefreshTableMetadataHandler init(RALBackendHandler.HandlerParameter<RefreshTableMetadataStatement> parameter) {
        this.sqlStatement = parameter.getStatement();
        this.connectionSession = parameter.getConnectionSession();
        return this;
    }

    @Override
    protected void update(ContextManager contextManager, RefreshTableMetadataStatement sqlStatement) throws DistSQLException {
        String databaseName = this.getDatabaseName();
        String schemaName = this.getSchemaName(sqlStatement, databaseName);
        if (sqlStatement.getResourceName().isPresent()) {
            if (sqlStatement.getTableName().isPresent()) {
                contextManager.reloadMetaData(databaseName, schemaName, (String)sqlStatement.getResourceName().get(), (String)sqlStatement.getTableName().get());
            } else {
                contextManager.reloadSchemaMetaData(databaseName, schemaName, (String)sqlStatement.getResourceName().get());
            }
            return;
        }
        if (sqlStatement.getTableName().isPresent()) {
            contextManager.reloadMetaData(databaseName, schemaName, (String)sqlStatement.getTableName().get());
            return;
        }
        contextManager.reloadMetaData(databaseName);
    }

    private String getDatabaseName() {
        String result = this.connectionSession.getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(result)) {
            throw new UnknownDatabaseException(result);
        }
        return result;
    }

    private String getSchemaName(RefreshTableMetadataStatement sqlStatement, String databaseName) {
        if (sqlStatement.getSchemaName().isPresent()) {
            return (String)sqlStatement.getSchemaName().get();
        }
        return DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.connectionSession.getDatabaseType(), (String)databaseName);
    }
}

