/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.swapper.DatabaseDiscoveryRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesValidator;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.ImportResourceNotExistedException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.exception.ImportDatabaseNotExistedException;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker.DatabaseDiscoveryRuleConfigurationImportChecker;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker.ReadwriteSplittingRuleConfigurationImportChecker;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker.ShardingRuleConfigurationImportChecker;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.config.YamlReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.swapper.ReadwriteSplittingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.ShadowRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationYamlSwapper;

public final class ImportDatabaseConfigurationHandler
extends UpdatableRALBackendHandler<ImportDatabaseConfigurationStatement, ImportDatabaseConfigurationHandler> {
    private final DataSourcePropertiesValidator validator = new DataSourcePropertiesValidator();
    private final ShardingRuleConfigurationImportChecker shardingRuleConfigurationImportChecker = new ShardingRuleConfigurationImportChecker();
    private final ReadwriteSplittingRuleConfigurationImportChecker readwriteSplittingRuleConfigurationImportChecker = new ReadwriteSplittingRuleConfigurationImportChecker();
    private final DatabaseDiscoveryRuleConfigurationImportChecker databaseDiscoveryRuleConfigurationImportChecker = new DatabaseDiscoveryRuleConfigurationImportChecker();
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();

    private void alterResourcesConfig(String databaseName, Map<String, YamlProxyDataSourceConfiguration> yamlDataSourceMap) throws DistSQLException {
        LinkedHashMap<String, DataSourceProperties> toBeUpdatedResourcePropsMap = new LinkedHashMap<String, DataSourceProperties>(yamlDataSourceMap.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDataSourceConfiguration> each2 : yamlDataSourceMap.entrySet()) {
            DataSourceProperties dataSourceProps = DataSourcePropertiesCreator.create((String)HikariDataSource.class.getName(), (DataSourceConfiguration)this.dataSourceConfigSwapper.swap(each2.getValue()));
            toBeUpdatedResourcePropsMap.put(each2.getKey(), dataSourceProps);
        }
        try {
            this.validator.validate(toBeUpdatedResourcePropsMap);
            LinkedList currentResourceNames = new LinkedList(ProxyContext.getInstance().getDatabase(databaseName).getResource().getDataSources().keySet());
            Collection toBeDroppedResourceNames = currentResourceNames.stream().filter(each -> !toBeUpdatedResourcePropsMap.containsKey(each)).collect(Collectors.toSet());
            ProxyContext.getInstance().getContextManager().addResource(databaseName, toBeUpdatedResourcePropsMap);
            if (!toBeDroppedResourceNames.isEmpty()) {
                ProxyContext.getInstance().getContextManager().dropResource(databaseName, toBeDroppedResourceNames);
            }
        }
        catch (SQLException ex) {
            throw new InvalidResourcesException(toBeUpdatedResourcePropsMap.keySet());
        }
    }

    private void alterRulesConfig(String databaseName, Collection<YamlRuleConfiguration> yamlRuleConfigs) throws DistSQLException {
        if (null == yamlRuleConfigs || yamlRuleConfigs.isEmpty()) {
            return;
        }
        LinkedList<Object> toBeUpdatedRuleConfigs = new LinkedList<Object>();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(databaseName);
        for (YamlRuleConfiguration each : yamlRuleConfigs) {
            if (each instanceof YamlShardingRuleConfiguration) {
                ShardingRuleConfiguration shardingRuleConfig = new ShardingRuleConfigurationYamlSwapper().swapToObject((YamlShardingRuleConfiguration)each);
                this.shardingRuleConfigurationImportChecker.check(database, shardingRuleConfig);
                toBeUpdatedRuleConfigs.add(shardingRuleConfig);
                continue;
            }
            if (each instanceof YamlReadwriteSplittingRuleConfiguration) {
                ReadwriteSplittingRuleConfiguration readwriteSplittingRuleConfig = new ReadwriteSplittingRuleConfigurationYamlSwapper().swapToObject((YamlReadwriteSplittingRuleConfiguration)each);
                this.readwriteSplittingRuleConfigurationImportChecker.check(database, readwriteSplittingRuleConfig);
                toBeUpdatedRuleConfigs.add(readwriteSplittingRuleConfig);
                continue;
            }
            if (each instanceof YamlDatabaseDiscoveryRuleConfiguration) {
                DatabaseDiscoveryRuleConfiguration databaseDiscoveryRuleConfig = new DatabaseDiscoveryRuleConfigurationYamlSwapper().swapToObject((YamlDatabaseDiscoveryRuleConfiguration)each);
                this.databaseDiscoveryRuleConfigurationImportChecker.check(database, databaseDiscoveryRuleConfig);
                toBeUpdatedRuleConfigs.add(databaseDiscoveryRuleConfig);
                continue;
            }
            if (each instanceof YamlEncryptRuleConfiguration) {
                EncryptRuleConfiguration encryptRuleConfig = new EncryptRuleConfigurationYamlSwapper().swapToObject((YamlEncryptRuleConfiguration)each);
                toBeUpdatedRuleConfigs.add(encryptRuleConfig);
                continue;
            }
            if (!(each instanceof YamlShadowRuleConfiguration)) continue;
            ShadowRuleConfiguration shadowRuleConfig = new ShadowRuleConfigurationYamlSwapper().swapToObject((YamlShadowRuleConfiguration)each);
            toBeUpdatedRuleConfigs.add(shadowRuleConfig);
        }
        database.getRuleMetaData().getConfigurations().clear();
        database.getRuleMetaData().getConfigurations().addAll(toBeUpdatedRuleConfigs);
        ProxyContext.getInstance().getContextManager().renewMetaDataContexts(metaDataContexts);
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        metaDataPersistService.ifPresent(optional -> optional.getDatabaseRulePersistService().persist(databaseName, toBeUpdatedRuleConfigs));
    }

    private void checkDatabaseName(String databaseName) {
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(databaseName)) {
            throw new DatabaseNotExistedException(databaseName);
        }
    }

    @Override
    protected void update(ContextManager contextManager, ImportDatabaseConfigurationStatement sqlStatement) throws DistSQLException {
        YamlProxyDatabaseConfiguration yamlConfig;
        if (!sqlStatement.getFilePath().isPresent()) {
            return;
        }
        File yamlFile = new File((String)sqlStatement.getFilePath().get());
        try {
            yamlConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyDatabaseConfiguration.class);
            if (null == yamlConfig) {
                return;
            }
        }
        catch (IOException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
        String databaseName = yamlConfig.getDatabaseName();
        DistSQLException.predictionThrow((!Strings.isNullOrEmpty((String)databaseName) ? 1 : 0) != 0, () -> new ImportDatabaseNotExistedException(yamlFile.getName()));
        this.checkDatabaseName(databaseName);
        DistSQLException.predictionThrow((null != yamlConfig.getDataSources() && !yamlConfig.getDataSources().isEmpty() ? 1 : 0) != 0, () -> new ImportResourceNotExistedException(yamlFile.getName()));
        this.alterResourcesConfig(databaseName, yamlConfig.getDataSources());
        this.alterRulesConfig(databaseName, yamlConfig.getRules());
    }
}

