/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.DropTrafficRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;

public final class DropTrafficRuleHandler
extends UpdatableRALBackendHandler<DropTrafficRuleStatement, DropTrafficRuleHandler> {
    @Override
    protected void update(ContextManager contextManager, DropTrafficRuleStatement sqlStatement) throws DistSQLException {
        Optional config = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRuleConfiguration(TrafficRuleConfiguration.class);
        if (!sqlStatement.isContainsIfExistClause()) {
            DistSQLException.predictionThrow((boolean)config.isPresent(), () -> new RequiredRuleMissedException("Traffic"));
            this.checkTrafficRuleConfiguration(sqlStatement, (TrafficRuleConfiguration)config.get());
        }
        if (config.isPresent()) {
            ((TrafficRuleConfiguration)config.get()).getTrafficStrategies().removeIf(each -> sqlStatement.getRuleNames().contains(each.getName()));
            this.getUnusedAlgorithm((TrafficRuleConfiguration)config.get()).forEach(each -> ((TrafficRuleConfiguration)config.get()).getTrafficAlgorithms().remove(each));
            this.getUnusedLoadBalancer((TrafficRuleConfiguration)config.get()).forEach(each -> ((TrafficRuleConfiguration)config.get()).getLoadBalancers().remove(each));
            this.updateToRepository((TrafficRuleConfiguration)config.get());
        }
    }

    private void checkTrafficRuleConfiguration(DropTrafficRuleStatement sqlStatement, TrafficRuleConfiguration config) throws DistSQLException {
        Set currentTrafficStrategyNames = config.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        Set notExistRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentTrafficStrategyNames.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistRuleNames.isEmpty(), () -> new RequiredRuleMissedException("Traffic"));
    }

    private Collection<String> getUnusedAlgorithm(TrafficRuleConfiguration config) {
        Collection currentlyInUse = config.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getAlgorithmName).collect(Collectors.toSet());
        return config.getTrafficAlgorithms().keySet().stream().filter(each -> !currentlyInUse.contains(each)).collect(Collectors.toSet());
    }

    private Collection<String> getUnusedLoadBalancer(TrafficRuleConfiguration config) {
        Collection currentlyInUse = config.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getLoadBalancerName).collect(Collectors.toSet());
        return config.getLoadBalancers().keySet().stream().filter(each -> !currentlyInUse.contains(each)).collect(Collectors.toSet());
    }

    private void updateToRepository(TrafficRuleConfiguration config) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        this.getUnusedLoadBalancer(config).forEach(each -> config.getLoadBalancers().remove(each));
        metaDataPersistService.ifPresent(optional -> optional.getGlobalRuleService().persist(metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), true));
    }
}

