/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.CreateTrafficRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.convert.TrafficRuleConverter;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.factory.TrafficAlgorithmFactory;
import org.apache.shardingsphere.traffic.factory.TrafficLoadBalanceAlgorithmFactory;

public final class CreateTrafficRuleHandler
extends UpdatableRALBackendHandler<CreateTrafficRuleStatement, CreateTrafficRuleHandler> {
    @Override
    protected void update(ContextManager contextManager, CreateTrafficRuleStatement sqlStatement) throws DistSQLException {
        Optional trafficRuleConfig = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(TrafficRuleConfiguration.class).stream().findAny();
        if (trafficRuleConfig.isPresent()) {
            this.checkTrafficRuleConfiguration(sqlStatement, (TrafficRuleConfiguration)trafficRuleConfig.get());
        }
        this.checkInvalidAlgorithmNames();
        this.updateToRepository(TrafficRuleConverter.convert(sqlStatement.getSegments()), trafficRuleConfig.orElse(null));
    }

    private void checkTrafficRuleConfiguration(CreateTrafficRuleStatement sqlStatement, TrafficRuleConfiguration trafficRuleConfig) throws DistSQLException {
        Collection currentRuleNames = trafficRuleConfig.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        Set duplicatedRuleNames = sqlStatement.getSegments().stream().map(TrafficRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("traffic", (Collection)duplicatedRuleNames));
    }

    private void checkInvalidAlgorithmNames() throws DistSQLException {
        LinkedList<String> invalidAlgorithmNames = new LinkedList<String>();
        for (TrafficRuleSegment each : ((CreateTrafficRuleStatement)this.sqlStatement).getSegments()) {
            if (!TrafficAlgorithmFactory.contains((String)each.getAlgorithm().getName())) {
                invalidAlgorithmNames.add(each.getAlgorithm().getName());
            }
            if (null == each.getLoadBalancer() || TrafficLoadBalanceAlgorithmFactory.contains((String)each.getLoadBalancer().getName())) continue;
            invalidAlgorithmNames.add(each.getLoadBalancer().getName());
        }
        DistSQLException.predictionThrow((boolean)invalidAlgorithmNames.isEmpty(), () -> new InvalidAlgorithmConfigurationException("traffic", invalidAlgorithmNames));
    }

    private void updateToRepository(TrafficRuleConfiguration toBeCreatedRuleConfig, TrafficRuleConfiguration currentRuleConfig) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Collection globalRuleConfigs = metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations();
        if (null == currentRuleConfig) {
            globalRuleConfigs.add(toBeCreatedRuleConfig);
        } else {
            this.setUpCurrentRuleConfiguration(toBeCreatedRuleConfig, currentRuleConfig);
        }
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        metaDataPersistService.ifPresent(optional -> optional.getGlobalRuleService().persist(globalRuleConfigs, true));
    }

    private void setUpCurrentRuleConfiguration(TrafficRuleConfiguration toBeCreatedRuleConfig, TrafficRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTrafficStrategies().addAll(toBeCreatedRuleConfig.getTrafficStrategies());
        currentRuleConfig.getTrafficAlgorithms().putAll(toBeCreatedRuleConfig.getTrafficAlgorithms());
        currentRuleConfig.getLoadBalancers().putAll(toBeCreatedRuleConfig.getLoadBalancers());
    }
}

