/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterTransactionRuleStatement;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable.AlterTrafficRuleHandler;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class AlterTransactionRuleHandler
extends UpdatableRALBackendHandler<AlterTransactionRuleStatement, AlterTrafficRuleHandler> {
    @Override
    protected void update(ContextManager contextManager, AlterTransactionRuleStatement sqlStatement) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereRuleMetaData globalRuleMetaData = metaDataContexts.getMetaData().getGlobalRuleMetaData();
        Collection globalRules = globalRuleMetaData.getRules();
        globalRules.removeIf(each -> each instanceof TransactionRule);
        LinkedList<Object> globalRuleConfigs = new LinkedList<Object>(globalRuleMetaData.getConfigurations());
        globalRuleConfigs.removeIf(each -> each instanceof TransactionRuleConfiguration);
        TransactionRuleConfiguration toBeAlteredRuleConfig = this.buildTransactionRuleConfiguration();
        globalRules.add(new TransactionRule(toBeAlteredRuleConfig));
        globalRuleConfigs.add(toBeAlteredRuleConfig);
        ProxyContext.getInstance().getContextManager().renewAllTransactionContext();
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        if (metaDataPersistService.isPresent() && null != ((MetaDataPersistService)metaDataPersistService.get()).getGlobalRuleService()) {
            ((MetaDataPersistService)metaDataPersistService.get()).getGlobalRuleService().persist(globalRuleConfigs, true);
        }
    }

    private TransactionRuleConfiguration buildTransactionRuleConfiguration() {
        return new TransactionRuleConfiguration(((AlterTransactionRuleStatement)this.sqlStatement).getDefaultType(), ((AlterTransactionRuleStatement)this.sqlStatement).getProvider().getProviderType(), ((AlterTransactionRuleStatement)this.sqlStatement).getProvider().getProps());
    }
}

