/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterTrafficRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.convert.TrafficRuleConverter;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.factory.TrafficAlgorithmFactory;
import org.apache.shardingsphere.traffic.factory.TrafficLoadBalanceAlgorithmFactory;

public final class AlterTrafficRuleHandler
extends UpdatableRALBackendHandler<AlterTrafficRuleStatement, AlterTrafficRuleHandler> {
    @Override
    protected void update(ContextManager contextManager, AlterTrafficRuleStatement sqlStatement) throws DistSQLException {
        Optional<TrafficRuleConfiguration> currentConfig = this.findCurrentConfiguration();
        DistSQLException.predictionThrow((boolean)currentConfig.isPresent(), () -> new RequiredRuleMissedException("Traffic"));
        this.check(sqlStatement, currentConfig.get());
        TrafficRuleConfiguration toBeAlteredConfig = TrafficRuleConverter.convert(sqlStatement.getSegments());
        this.persistNewRuleConfigurations(toBeAlteredConfig, currentConfig.get());
    }

    private Optional<TrafficRuleConfiguration> findCurrentConfiguration() {
        return ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(TrafficRuleConfiguration.class).stream().findAny();
    }

    private void check(AlterTrafficRuleStatement sqlStatement, TrafficRuleConfiguration currentConfig) throws DistSQLException {
        Collection currentRuleNames = currentConfig.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        Set notExistRuleNames = sqlStatement.getSegments().stream().map(TrafficRuleSegment::getName).filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistRuleNames.isEmpty(), () -> new RequiredRuleMissedException("Traffic", (Collection)notExistRuleNames));
        Collection<String> invalidAlgorithmNames = this.getInvalidAlgorithmNames();
        DistSQLException.predictionThrow((boolean)invalidAlgorithmNames.isEmpty(), () -> new InvalidAlgorithmConfigurationException("traffic", invalidAlgorithmNames));
    }

    private Collection<String> getInvalidAlgorithmNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (TrafficRuleSegment each : ((AlterTrafficRuleStatement)this.sqlStatement).getSegments()) {
            if (!TrafficAlgorithmFactory.contains((String)each.getAlgorithm().getName())) {
                result.add(each.getAlgorithm().getName());
            }
            if (null == each.getLoadBalancer() || TrafficLoadBalanceAlgorithmFactory.contains((String)each.getLoadBalancer().getName())) continue;
            result.add(each.getLoadBalancer().getName());
        }
        return result;
    }

    private void persistNewRuleConfigurations(TrafficRuleConfiguration toBeAlteredConfig, TrafficRuleConfiguration currentConfig) {
        Collection toBeAlteredConfigNames = toBeAlteredConfig.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        currentConfig.getTrafficStrategies().removeIf(each -> toBeAlteredConfigNames.contains(each.getName()));
        currentConfig.getTrafficStrategies().addAll(toBeAlteredConfig.getTrafficStrategies());
        currentConfig.getTrafficAlgorithms().putAll(toBeAlteredConfig.getTrafficAlgorithms());
        currentConfig.getLoadBalancers().putAll(toBeAlteredConfig.getLoadBalancers());
        this.getUnusedLoadBalancer(currentConfig).forEach(each -> currentConfig.getLoadBalancers().remove(each));
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional metaDataPersistService = metaDataContexts.getPersistService();
        metaDataPersistService.ifPresent(optional -> optional.getGlobalRuleService().persist(metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), true));
    }

    private Collection<String> getUnusedLoadBalancer(TrafficRuleConfiguration currentConfig) {
        Collection currentlyInUse = currentConfig.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getLoadBalancerName).collect(Collectors.toSet());
        return currentConfig.getLoadBalancers().keySet().stream().filter(each -> !currentlyInUse.contains(each)).collect(Collectors.toSet());
    }
}

