/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.segment.CacheOptionSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterSQLParserRuleStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.parser.rule.builder.DefaultSQLParserRuleConfigurationBuilder;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class AlterSQLParserRuleHandler
extends UpdatableRALBackendHandler<AlterSQLParserRuleStatement, AlterSQLParserRuleHandler> {
    @Override
    protected void update(ContextManager contextManager, AlterSQLParserRuleStatement sqlStatement) {
        Optional<SQLParserRuleConfiguration> currentConfig = this.findCurrentConfiguration();
        SQLParserRuleConfiguration toBeAlteredRuleConfig = this.createSQLParserRuleConfiguration(currentConfig.orElseGet(() -> new DefaultSQLParserRuleConfigurationBuilder().build()));
        Collection globalRuleConfigs = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getConfigurations();
        globalRuleConfigs.removeIf(each -> each instanceof SQLParserRuleConfiguration);
        globalRuleConfigs.add(toBeAlteredRuleConfig);
        this.persistNewRuleConfigurations(globalRuleConfigs);
    }

    private Optional<SQLParserRuleConfiguration> findCurrentConfiguration() {
        return ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(SQLParserRuleConfiguration.class).stream().findAny();
    }

    private SQLParserRuleConfiguration createSQLParserRuleConfiguration(SQLParserRuleConfiguration currentConfig) {
        SQLParserRuleConfiguration result = new SQLParserRuleConfiguration();
        result.setSqlCommentParseEnabled(null == ((AlterSQLParserRuleStatement)this.sqlStatement).getSqlCommentParseEnable() ? currentConfig.isSqlCommentParseEnabled() : ((AlterSQLParserRuleStatement)this.sqlStatement).getSqlCommentParseEnable().booleanValue());
        result.setParseTreeCache(null == ((AlterSQLParserRuleStatement)this.sqlStatement).getParseTreeCache() ? currentConfig.getParseTreeCache() : this.createCacheOption(currentConfig.getParseTreeCache(), ((AlterSQLParserRuleStatement)this.sqlStatement).getParseTreeCache()));
        result.setSqlStatementCache(null == ((AlterSQLParserRuleStatement)this.sqlStatement).getSqlStatementCache() ? currentConfig.getSqlStatementCache() : this.createCacheOption(currentConfig.getSqlStatementCache(), ((AlterSQLParserRuleStatement)this.sqlStatement).getSqlStatementCache()));
        return result;
    }

    private CacheOption createCacheOption(CacheOption cacheOption, CacheOptionSegment segment) {
        int initialCapacity = null == segment.getInitialCapacity() ? cacheOption.getInitialCapacity() : segment.getInitialCapacity().intValue();
        long maximumSize = null == segment.getMaximumSize() ? cacheOption.getMaximumSize() : segment.getMaximumSize().longValue();
        return new CacheOption(initialCapacity, maximumSize);
    }

    private void persistNewRuleConfigurations(Collection<RuleConfiguration> globalRuleConfigs) {
        Optional metaDataPersistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService();
        if (metaDataPersistService.isPresent() && null != ((MetaDataPersistService)metaDataPersistService.get()).getGlobalRuleService()) {
            ((MetaDataPersistService)metaDataPersistService.get()).getGlobalRuleService().persist(globalRuleConfigs, true);
        }
    }
}

