/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.updatable;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterInstanceStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdChangedEvent;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.UpdatableRALBackendHandler;

public final class AlterInstanceHandler
extends UpdatableRALBackendHandler<AlterInstanceStatement, AlterInstanceHandler> {
    private static final String XA_RECOVERY_NODES = "xa_recovery_nodes";

    @Override
    protected void update(ContextManager contextManager, AlterInstanceStatement sqlStatement) throws DistSQLException {
        if (!XA_RECOVERY_NODES.equalsIgnoreCase(sqlStatement.getKey())) {
            throw new UnsupportedOperationException(String.format("%s is not supported", sqlStatement.getKey()));
        }
        this.setXaRecoveryId(contextManager, sqlStatement);
    }

    private void setXaRecoveryId(ContextManager contextManager, AlterInstanceStatement sqlStatement) {
        Optional persistService = contextManager.getMetaDataContexts().getPersistService();
        if (!persistService.isPresent()) {
            throw new UnsupportedOperationException(String.format("No persistence configuration found, unable to set '%s'", sqlStatement.getKey()));
        }
        if (!contextManager.getInstanceContext().getComputeNodeInstanceById(sqlStatement.getInstanceId()).isPresent()) {
            throw new UnsupportedOperationException(String.format("'%s' does not exist", sqlStatement.getInstanceId()));
        }
        ShardingSphereEventBus.getInstance().post((Object)new XaRecoveryIdChangedEvent(sqlStatement.getInstanceId(), (Collection)Splitter.on((String)",").splitToList((CharSequence)sqlStatement.getValue())));
    }
}

