/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ShowVariableHandler
extends QueryableRALBackendHandler<ShowVariableStatement, ShowVariableHandler> {
    private static final String VARIABLE_NAME = "variable_name";
    private static final String VARIABLE_VALUE = "variable_value";
    private ConnectionSession connectionSession;

    @Override
    public ShowVariableHandler init(RALBackendHandler.HandlerParameter<ShowVariableStatement> parameter) {
        this.initStatement(parameter.getStatement());
        this.connectionSession = parameter.getConnectionSession();
        return this;
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(VARIABLE_NAME, VARIABLE_VALUE);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        if (this.hasSpecifiedKey()) {
            return this.buildSpecifiedRow(contextManager, ((ShowVariableStatement)this.sqlStatement).getName());
        }
        return this.buildAllVariableRows(contextManager);
    }

    private boolean hasSpecifiedKey() {
        return !Strings.isNullOrEmpty((String)((ShowVariableStatement)this.sqlStatement).getName());
    }

    private Collection<List<Object>> buildAllVariableRows(ContextManager contextManager) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        ConfigurationProperties props = contextManager.getMetaDataContexts().getMetaData().getProps();
        ConfigurationPropertyKey.getKeyNames().forEach(each -> {
            String propertyValue = props.getValue((Enum)ConfigurationPropertyKey.valueOf((String)each)).toString();
            result.add(Arrays.asList(each.toLowerCase(), propertyValue));
        });
        result.add(Arrays.asList(VariableEnum.AGENT_PLUGINS_ENABLED.name().toLowerCase(), SystemPropertyUtil.getSystemProperty(VariableEnum.AGENT_PLUGINS_ENABLED.name(), Boolean.TRUE.toString())));
        if (this.connectionSession.getBackendConnection() instanceof JDBCBackendConnection) {
            result.add(Arrays.asList(VariableEnum.CACHED_CONNECTIONS.name().toLowerCase(), ((JDBCBackendConnection)this.connectionSession.getBackendConnection()).getConnectionSize()));
        }
        result.add(Arrays.asList(VariableEnum.TRANSACTION_TYPE.name().toLowerCase(), this.connectionSession.getTransactionStatus().getTransactionType().name()));
        return result;
    }

    private Collection<List<Object>> buildSpecifiedRow(ContextManager contextManager, String key) {
        if (this.isConfigurationKey(key)) {
            return Collections.singletonList(Arrays.asList(key.toLowerCase(), this.getConfigurationValue(contextManager, key)));
        }
        return Collections.singletonList(Arrays.asList(key.toLowerCase(), this.getSpecialValue(key)));
    }

    private boolean isConfigurationKey(String key) {
        return ConfigurationPropertyKey.getKeyNames().contains(key);
    }

    private String getConfigurationValue(ContextManager contextManager, String key) {
        return contextManager.getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)key)).toString();
    }

    private String getSpecialValue(String key) {
        VariableEnum variable = VariableEnum.getValueOf(key);
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                return SystemPropertyUtil.getSystemProperty(variable.name(), Boolean.TRUE.toString());
            }
            case CACHED_CONNECTIONS: {
                if (!(this.connectionSession.getBackendConnection() instanceof JDBCBackendConnection)) break;
                int connectionSize = ((JDBCBackendConnection)this.connectionSession.getBackendConnection()).getConnectionSize();
                return String.valueOf(connectionSize);
            }
            case TRANSACTION_TYPE: {
                TransactionType transactionType = this.connectionSession.getTransactionStatus().getTransactionType();
                return transactionType.name();
            }
        }
        throw new UnsupportedVariableException(key);
    }
}

