/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowTrafficRulesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;

public final class ShowTrafficRulesHandler
extends QueryableRALBackendHandler<ShowTrafficRulesStatement, ShowTrafficRulesHandler> {
    private static final String RULE_NAME = "name";
    private static final String LABELS = "labels";
    private static final String ALGORITHM_TYPE = "algorithm_type";
    private static final String ALGORITHM_PROPS = "algorithm_props";
    private static final String LOAD_BALANCER_TYPE = "load_balancer_type";
    private static final String LOAD_BALANCER_PROPS = "load_balancer_props";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(RULE_NAME, LABELS, ALGORITHM_TYPE, ALGORITHM_PROPS, LOAD_BALANCER_TYPE, LOAD_BALANCER_PROPS);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        Optional config = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(TrafficRuleConfiguration.class).stream().findAny();
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        Optional<String> ruleName = Optional.ofNullable(((ShowTrafficRulesStatement)this.sqlStatement).getRuleName());
        config.ifPresent(optional -> {
            Map trafficAlgorithms = optional.getTrafficAlgorithms();
            Map loadBalancers = optional.getLoadBalancers();
            optional.getTrafficStrategies().stream().filter(each -> !ruleName.isPresent() || each.getName().equals(ruleName.get())).forEach(each -> result.add(this.buildRow((TrafficStrategyConfiguration)each, (ShardingSphereAlgorithmConfiguration)trafficAlgorithms.get(each.getAlgorithmName()), (ShardingSphereAlgorithmConfiguration)loadBalancers.get(each.getLoadBalancerName()))));
        });
        return result;
    }

    private List<Object> buildRow(TrafficStrategyConfiguration strategy, ShardingSphereAlgorithmConfiguration trafficAlgorithm, ShardingSphereAlgorithmConfiguration loadBalancer) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(strategy.getName());
        result.add(String.join((CharSequence)",", strategy.getLabels()));
        result.add(null != trafficAlgorithm ? trafficAlgorithm.getType() : "");
        result.add(null != trafficAlgorithm ? PropertiesConverter.convert((Properties)trafficAlgorithm.getProps()) : "");
        result.add(null != loadBalancer ? loadBalancer.getType() : "");
        result.add(null != loadBalancer ? PropertiesConverter.convert((Properties)loadBalancer.getProps()) : "");
        return result;
    }

    @Generated
    public ShowTrafficRulesHandler() {
    }
}

