/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowTableMetadataStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class ShowTableMetadataHandler
extends QueryableRALBackendHandler<ShowTableMetadataStatement, ShowTableMetadataHandler> {
    private static final String SCHEMA_NAME = "schema_name";
    private static final String TABLE_NAME = "table_name";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private ConnectionSession connectionSession;

    @Override
    public ShowTableMetadataHandler init(RALBackendHandler.HandlerParameter<ShowTableMetadataStatement> parameter) {
        this.connectionSession = parameter.getConnectionSession();
        return (ShowTableMetadataHandler)super.init(parameter);
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(SCHEMA_NAME, TABLE_NAME, TYPE, NAME);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        String databaseName = this.getDatabaseName();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.connectionSession.getDatabaseType(), (String)this.connectionSession.getDatabaseName());
        ShardingSphereSchema schema = (ShardingSphereSchema)ProxyContext.getInstance().getDatabase(databaseName).getSchemas().get(defaultSchema);
        return schema.getAllTableNames().stream().filter(each -> ((ShowTableMetadataStatement)this.sqlStatement).getTableNames().contains(each)).map(each -> this.buildTableRows(databaseName, schema, (String)each)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String getDatabaseName() {
        String result;
        String string = result = ((ShowTableMetadataStatement)this.sqlStatement).getDatabase().isPresent() ? ((DatabaseSegment)((ShowTableMetadataStatement)this.sqlStatement).getDatabase().get()).getIdentifier().getValue() : this.connectionSession.getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(result)) {
            throw new DatabaseNotExistedException(result);
        }
        return result;
    }

    private Collection<List<Object>> buildTableRows(String databaseName, ShardingSphereSchema schema, String tableName) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        Collection columnRows = schema.getAllColumnNames(tableName).stream().map(each -> this.buildRow(databaseName, tableName, "COLUMN", (String)each)).collect(Collectors.toList());
        Collection indexRows = ((ShardingSphereTable)schema.getTables().get(tableName)).getIndexes().values().stream().map(ShardingSphereIndex::getName).map(each -> this.buildRow(databaseName, tableName, "INDEX", (String)each)).collect(Collectors.toList());
        result.addAll(columnRows);
        result.addAll(indexRows);
        return result;
    }

    private List<Object> buildRow(String databaseName, String tableName, String type, String name) {
        return new ArrayList<Object>(Arrays.asList(databaseName, tableName, type, name));
    }
}

