/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowSQLParserRuleStatement;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;

public final class ShowSQLParserRuleHandler
extends QueryableRALBackendHandler<ShowSQLParserRuleStatement, ShowSQLParserRuleHandler> {
    private static final Gson GSON = new Gson();
    private static final String SQL_COMMENT_PARSE_ENABLE = "sql_comment_parse_enable";
    private static final String PARSE_TREE_CACHE = "parse_tree_cache";
    private static final String SQL_STATEMENT_CACHE = "sql_statement_cache";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(SQL_COMMENT_PARSE_ENABLE, PARSE_TREE_CACHE, SQL_STATEMENT_CACHE);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        Optional sqlParserRuleConfig = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(SQLParserRuleConfiguration.class).stream().findAny();
        return sqlParserRuleConfig.isPresent() ? Collections.singleton(this.getRow((SQLParserRuleConfiguration)sqlParserRuleConfig.get())) : Collections.emptyList();
    }

    private List<Object> getRow(SQLParserRuleConfiguration sqlParserRuleConfig) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(String.valueOf(sqlParserRuleConfig.isSqlCommentParseEnabled()));
        result.add(GSON.toJson((Object)sqlParserRuleConfig.getParseTreeCache()));
        result.add(GSON.toJson((Object)sqlParserRuleConfig.getSqlStatementCache()));
        return result;
    }
}

