/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service.StorageNodeStatusService;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingReadResourcesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class ShowReadwriteSplittingReadResourcesHandler
extends QueryableRALBackendHandler<ShowReadwriteSplittingReadResourcesStatement, ShowReadwriteSplittingReadResourcesHandler> {
    private static final String RESOURCE = "resource";
    private static final String STATUS = "status";
    private static final String DELAY_TIME = "delay_time(ms)";
    private ConnectionSession connectionSession;

    @Override
    public ShowReadwriteSplittingReadResourcesHandler init(RALBackendHandler.HandlerParameter<ShowReadwriteSplittingReadResourcesStatement> parameter) {
        this.connectionSession = parameter.getConnectionSession();
        return (ShowReadwriteSplittingReadResourcesHandler)super.init(parameter);
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(RESOURCE, STATUS, DELAY_TIME);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        String databaseName = this.getDatabaseName();
        MetaDataContexts metaDataContexts = contextManager.getMetaDataContexts();
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(databaseName);
        Collection<String> allReadResources = this.getAllReadResources(database);
        Map<String, StorageNodeDataSource> persistentReadResources = this.getPersistentReadResources(databaseName, metaDataContexts.getPersistService().orElse(null));
        return this.buildRows(allReadResources, persistentReadResources);
    }

    private String getDatabaseName() {
        String result;
        String string = result = ((ShowReadwriteSplittingReadResourcesStatement)this.sqlStatement).getDatabase().isPresent() ? ((DatabaseSegment)((ShowReadwriteSplittingReadResourcesStatement)this.sqlStatement).getDatabase().get()).getIdentifier().getValue() : this.connectionSession.getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(result)) {
            throw new DatabaseNotExistedException(result);
        }
        return result;
    }

    private Collection<String> getAllReadResources(ShardingSphereDatabase database) {
        List<String> exportKeys = Arrays.asList("static_readwrite_splitting_rules", "dynamic_readwrite_splitting_rules");
        Map exportMap = database.getRuleMetaData().getRules().stream().filter(each -> each instanceof ExportableRule).map(each -> (ExportableRule)each).filter(each -> each.containExportableKey(exportKeys)).findFirst().map(each -> each.export(exportKeys)).orElse(Collections.emptyMap());
        Map allReadwriteRuleMap = exportMap.values().stream().map(each -> ((Map)each).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
        return allReadwriteRuleMap.values().stream().map(each -> each.getOrDefault("replica_data_source_names", "")).map(this::deconstructString).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<String, StorageNodeDataSource> getPersistentReadResources(String databaseName, MetaDataPersistService persistService) {
        if (null == persistService || null == persistService.getRepository() || !(persistService.getRepository() instanceof ClusterPersistRepository)) {
            return Collections.emptyMap();
        }
        Map storageNodes = new StorageNodeStatusService((ClusterPersistRepository)persistService.getRepository()).loadStorageNodes();
        HashMap<String, StorageNodeDataSource> result = new HashMap<String, StorageNodeDataSource>();
        storageNodes.entrySet().stream().filter(entry -> "member".equalsIgnoreCase(((StorageNodeDataSource)entry.getValue()).getRole())).forEach(entry -> {
            QualifiedDatabase qualifiedSchema = new QualifiedDatabase((String)entry.getKey());
            if (databaseName.equalsIgnoreCase(qualifiedSchema.getDatabaseName())) {
                result.put(qualifiedSchema.getDataSourceName(), (StorageNodeDataSource)entry.getValue());
            }
        });
        return result;
    }

    private Collection<List<Object>> buildRows(Collection<String> readResources, Map<String, StorageNodeDataSource> persistentReadResources) {
        Map<String, Map<String, StorageNodeDataSource>> persistentReadResourceGroup = persistentReadResources.entrySet().stream().collect(Collectors.groupingBy(each -> ((StorageNodeDataSource)each.getValue()).getStatus().toUpperCase(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Map disabledReadResources = persistentReadResourceGroup.getOrDefault(StorageNodeStatus.DISABLED.name(), Collections.emptyMap());
        Map enabledReadResources = persistentReadResourceGroup.getOrDefault(StorageNodeStatus.ENABLED.name(), Collections.emptyMap());
        readResources.removeIf(disabledReadResources::containsKey);
        readResources.addAll(enabledReadResources.keySet());
        readResources.addAll(disabledReadResources.keySet());
        return readResources.stream().map(each -> this.buildRow((String)each, (StorageNodeDataSource)disabledReadResources.get(each))).collect(Collectors.toCollection(LinkedList::new));
    }

    private LinkedList<String> deconstructString(String str) {
        return new LinkedList<String>(Arrays.asList(str.split(",")));
    }

    private List<Object> buildRow(String resource, StorageNodeDataSource storageNodeDataSource) {
        if (null == storageNodeDataSource) {
            return Arrays.asList(resource, StorageNodeStatus.ENABLED.name().toLowerCase(), "0");
        }
        long replicationDelayMilliseconds = storageNodeDataSource.getReplicationDelayMilliseconds();
        String status = StorageNodeStatus.valueOf((String)storageNodeDataSource.getStatus().toUpperCase()).name().toLowerCase();
        return Arrays.asList(resource, status, Long.toString(replicationDelayMilliseconds));
    }
}

