/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowInstanceModeStatement;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;

public final class ShowInstanceModeHandler
extends QueryableRALBackendHandler<ShowInstanceModeStatement, ShowInstanceModeHandler> {
    private static final String INSTANCE_ID = "instance_id";
    private static final String TYPE = "type";
    private static final String REPOSITORY = "repository";
    private static final String PROPS = "props";
    private static final String OVERWRITE = "overwrite";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(INSTANCE_ID, TYPE, REPOSITORY, PROPS, OVERWRITE);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        InstanceContext instanceContext = ProxyContext.getInstance().getContextManager().getInstanceContext();
        PersistRepositoryConfiguration repositoryConfig = instanceContext.getModeConfiguration().getRepository();
        String instanceId = instanceContext.getInstance().getInstanceDefinition().getInstanceId();
        String modeType = instanceContext.getModeConfiguration().getType();
        String repositoryType = null == repositoryConfig ? "" : repositoryConfig.getType();
        String props = null == repositoryConfig || null == repositoryConfig.getProps() ? "" : new Gson().toJson((Object)repositoryConfig.getProps());
        String overwrite = String.valueOf(instanceContext.getModeConfiguration().isOverwrite());
        return Collections.singleton(Arrays.asList(instanceId, modeType, repositoryType, props, overwrite));
    }
}

