/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowInstanceStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;

public final class ShowInstanceHandler
extends QueryableRALBackendHandler<ShowInstanceStatement, ShowInstanceHandler> {
    private static final String DELIMITER = "@";
    private static final String ID = "instance_id";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String STATUS = "status";
    private static final String MODE_TYPE = "mode_type";
    private static final String LABELS = "labels";
    private static final String XA_RECOVERY_NODES = "xa_recovery_nodes";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(ID, HOST, PORT, STATUS, MODE_TYPE, LABELS, XA_RECOVERY_NODES);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        return this.buildInstanceRows(contextManager);
    }

    private Collection<List<Object>> buildInstanceRows(ContextManager contextManager) {
        String modeType = contextManager.getInstanceContext().getModeConfiguration().getType();
        if ("Memory".equalsIgnoreCase(modeType) || "Standalone".equalsIgnoreCase(modeType)) {
            return Collections.singletonList(this.buildRow(contextManager.getInstanceContext().getInstance(), modeType));
        }
        Collection instances = contextManager.getInstanceContext().getComputeNodeInstances().stream().filter(each -> InstanceType.PROXY.equals((Object)each.getInstanceDefinition().getInstanceType())).collect(Collectors.toList());
        return instances.isEmpty() ? Collections.emptyList() : (Collection)instances.stream().filter(Objects::nonNull).map(each -> this.buildRow((ComputeNodeInstance)each, modeType)).collect(Collectors.toList());
    }

    private List<Object> buildRow(ComputeNodeInstance instance, String modeType) {
        return this.buildRow(instance.getInstanceDefinition(), instance.getState().getCurrentState().name(), modeType, instance.getLabels(), Joiner.on((String)",").join((Iterable)instance.getXaRecoveryIds()));
    }

    private List<Object> buildRow(InstanceDefinition instanceDefinition, String status, String modeType, Collection<String> instanceLabels, String xaRecoveryId) {
        String host = instanceDefinition.getIp();
        String port = instanceDefinition.getUniqueSign();
        String labels = null == instanceLabels ? "" : String.join((CharSequence)",", instanceLabels);
        return new LinkedList<Object>(Arrays.asList(instanceDefinition.getInstanceId(), host, port, status, modeType, labels, null == xaRecoveryId ? "" : xaRecoveryId));
    }
}

