/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowAuthorityRuleStatement;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;

public final class ShowAuthorityRuleHandler
extends QueryableRALBackendHandler<ShowAuthorityRuleStatement, ShowAuthorityRuleHandler> {
    private static final String USERS = "users";
    private static final String PROVIDER = "provider";
    private static final String PROPS = "props";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(USERS, PROVIDER, PROPS);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        Optional authorityRuleConfig = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findRuleConfigurations(AuthorityRuleConfiguration.class).stream().findFirst();
        return authorityRuleConfig.isPresent() ? Collections.singleton(this.getRow((AuthorityRuleConfiguration)authorityRuleConfig.get())) : Collections.emptyList();
    }

    private List<Object> getRow(AuthorityRuleConfiguration authorityRuleConfig) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(authorityRuleConfig.getUsers().stream().map(each -> each.getGrantee().toString()).collect(Collectors.joining("; ")));
        result.add(authorityRuleConfig.getProvider().getType());
        result.add(authorityRuleConfig.getProvider().getProps().size() == 0 ? "" : authorityRuleConfig.getProvider().getProps());
        return result;
    }
}

