/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.swapper.DatabaseDiscoveryRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.swapper.ReadwriteSplittingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.ShadowRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class ExportDatabaseConfigurationHandler
extends QueryableRALBackendHandler<ExportDatabaseConfigurationStatement, ExportDatabaseConfigurationHandler> {
    private static final String RESULT = "result";
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON_NEWLINE = ":\n";
    private static final String INDENT = "  ";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final String SHARDING = "sharding";
    private static final String READWRITE_SPLITTING = "readwrite_splitting";
    private static final String DB_DISCOVERY = "db_discovery";
    private static final String ENCRYPT = "encrypt";
    private static final String SHADOW = "shadow";
    private static final Map<String, Class<? extends RuleConfiguration>> FEATURE_MAP = new HashMap<String, Class<? extends RuleConfiguration>>(5, 1.0f);
    private ConnectionSession connectionSession;

    @Override
    public ExportDatabaseConfigurationHandler init(RALBackendHandler.HandlerParameter<ExportDatabaseConfigurationStatement> parameter) {
        this.connectionSession = parameter.getConnectionSession();
        return (ExportDatabaseConfigurationHandler)super.init(parameter);
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Collections.singletonList(RESULT);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        String databaseName = this.getDatabaseName();
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(databaseName);
        StringBuilder result = new StringBuilder();
        this.configItem(0, "databaseName", databaseName, result);
        this.getDataSourcesConfig(database, result);
        this.getRuleConfigurations(database.getRuleMetaData().getConfigurations(), result);
        if (!((ExportDatabaseConfigurationStatement)this.sqlStatement).getFilePath().isPresent()) {
            return Collections.singleton(Collections.singletonList(result.toString()));
        }
        File outFile = new File((String)((ExportDatabaseConfigurationStatement)this.sqlStatement).getFilePath().get());
        if (!outFile.exists()) {
            outFile.getParentFile().mkdirs();
        }
        try (FileOutputStream stream = new FileOutputStream(outFile);){
            stream.write(result.toString().getBytes());
            stream.flush();
        }
        catch (IOException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
        return Collections.singleton(Collections.singletonList(String.format("Successfully exported to\uff1a'%s'", ((ExportDatabaseConfigurationStatement)this.sqlStatement).getFilePath().get())));
    }

    private void getDataSourcesConfig(ShardingSphereDatabase database, StringBuilder result) {
        if (null == database.getResource().getDataSources() || database.getResource().getDataSources().isEmpty()) {
            return;
        }
        this.configItem(0, "dataSources", result);
        for (Map.Entry each : database.getResource().getDataSources().entrySet()) {
            this.configItem(1, each.getKey(), result);
            DataSourceProperties dataSourceProps = DataSourcePropertiesCreator.create((DataSource)((DataSource)each.getValue()));
            dataSourceProps.getConnectionPropertySynonyms().getStandardProperties().forEach((key, value) -> this.configItem(2, key, value, result));
            dataSourceProps.getPoolPropertySynonyms().getStandardProperties().forEach((key, value) -> this.configItem(2, key, value, result));
        }
    }

    private void getRuleConfigurations(Collection<RuleConfiguration> ruleConfigs, StringBuilder result) {
        if (null == ruleConfigs || ruleConfigs.isEmpty()) {
            return;
        }
        this.configItem(0, "rules", result);
        ruleConfigs.forEach(each -> {
            this.getRulesConfigForSharding((RuleConfiguration)each, result);
            this.getRulesConfigForReadwriteSplitting((RuleConfiguration)each, result);
            this.getRulesConfigForDBDiscovery((RuleConfiguration)each, result);
            this.getRulesConfigForEncrypt((RuleConfiguration)each, result);
            this.getRulesConfigForShadow((RuleConfiguration)each, result);
        });
    }

    private boolean matchFeature(RuleConfiguration ruleConfig, String feature) {
        return null != ruleConfig && ruleConfig.getClass().getCanonicalName().equalsIgnoreCase(FEATURE_MAP.get(feature).getCanonicalName());
    }

    private void getRulesConfigForSharding(RuleConfiguration ruleConfig, StringBuilder result) {
        if (this.matchFeature(ruleConfig, SHARDING)) {
            result.append(YamlEngine.marshal(Collections.singletonList(new ShardingRuleConfigurationYamlSwapper().swapToYamlConfiguration((ShardingRuleConfiguration)ruleConfig))));
        }
    }

    private void getRulesConfigForReadwriteSplitting(RuleConfiguration ruleConfig, StringBuilder result) {
        if (this.matchFeature(ruleConfig, READWRITE_SPLITTING)) {
            result.append(YamlEngine.marshal(Collections.singletonList(new ReadwriteSplittingRuleConfigurationYamlSwapper().swapToYamlConfiguration((ReadwriteSplittingRuleConfiguration)ruleConfig))));
        }
    }

    private void getRulesConfigForDBDiscovery(RuleConfiguration ruleConfig, StringBuilder result) {
        if (this.matchFeature(ruleConfig, DB_DISCOVERY)) {
            result.append(YamlEngine.marshal(Collections.singletonList(new DatabaseDiscoveryRuleConfigurationYamlSwapper().swapToYamlConfiguration((DatabaseDiscoveryRuleConfiguration)ruleConfig))));
        }
    }

    private void getRulesConfigForEncrypt(RuleConfiguration ruleConfig, StringBuilder result) {
        if (this.matchFeature(ruleConfig, ENCRYPT)) {
            result.append(YamlEngine.marshal(Collections.singletonList(new EncryptRuleConfigurationYamlSwapper().swapToYamlConfiguration((EncryptRuleConfiguration)ruleConfig))));
        }
    }

    private void getRulesConfigForShadow(RuleConfiguration ruleConfig, StringBuilder result) {
        if (this.matchFeature(ruleConfig, SHADOW)) {
            result.append(YamlEngine.marshal(Collections.singletonList(new ShadowRuleConfigurationYamlSwapper().swapToYamlConfiguration((ShadowRuleConfiguration)ruleConfig))));
        }
    }

    private void configItem(int indent, Object key, StringBuilder result) {
        result.append(this.indent(indent)).append(key).append(COLON_NEWLINE);
    }

    private void configItem(int indent, Object key, Object value, StringBuilder result) {
        result.append(this.indent(indent)).append(key).append(COLON_SPACE).append(value).append(NEWLINE);
    }

    private String indent(int count) {
        if (count <= 0) {
            return "";
        }
        if (1 == count) {
            return INDENT;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(INDENT);
        }
        return result.toString();
    }

    private String getDatabaseName() {
        String result;
        String string = result = ((ExportDatabaseConfigurationStatement)this.sqlStatement).getDatabase().isPresent() ? ((DatabaseSegment)((ExportDatabaseConfigurationStatement)this.sqlStatement).getDatabase().get()).getIdentifier().getValue() : this.connectionSession.getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(result)) {
            throw new DatabaseNotExistedException(result);
        }
        return result;
    }

    static {
        FEATURE_MAP.put(SHARDING, ShardingRuleConfiguration.class);
        FEATURE_MAP.put(READWRITE_SPLITTING, ReadwriteSplittingRuleConfiguration.class);
        FEATURE_MAP.put(DB_DISCOVERY, DatabaseDiscoveryRuleConfiguration.class);
        FEATURE_MAP.put(ENCRYPT, EncryptRuleConfiguration.class);
        FEATURE_MAP.put(SHADOW, ShadowRuleConfiguration.class);
    }
}

