/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.queryable;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.CountInstanceRulesStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;

public final class CountInstanceRulesHandler
extends QueryableRALBackendHandler<CountInstanceRulesStatement, CountInstanceRulesHandler> {
    private static final int DEFAULT_COUNT = 0;
    private static final String SINGLE_TABLE = "single_table";
    private static final String SHARDING_TABLE = "sharding_table";
    private static final String SHARDING_BINDING_TABLE = "sharding_binding_table";
    private static final String SHARDING_BROADCAST_TABLE = "sharding_broadcast_table";
    private static final String SHARDING_SCALING = "sharding_scaling";
    private static final String READWRITE_SPLITTING = "readwrite_splitting";
    private static final String DB_DISCOVERY = "db_discovery";
    private static final String ENCRYPT = "encrypt";
    private static final String SHADOW = "shadow";

    @Override
    public Collection<String> getColumnNames() {
        return Arrays.asList("rule_name", "count");
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) throws SQLException {
        LinkedHashMap dataMap = new LinkedHashMap();
        ProxyContext.getInstance().getAllDatabaseNames().forEach(each -> this.addSchemaData(dataMap, ProxyContext.getInstance().getDatabase((String)each)));
        return dataMap.values();
    }

    private void addSchemaData(Map<String, List<Object>> dataMap, ShardingSphereDatabase database) {
        this.initData(dataMap);
        Collection singleTableRules = database.getRuleMetaData().findRules(SingleTableRule.class);
        if (!singleTableRules.isEmpty()) {
            this.addSingleTableData(dataMap, singleTableRules);
        }
        if (this.hasRuleConfiguration(database)) {
            this.addConfigurationData(dataMap, database.getRuleMetaData().getConfigurations());
        }
    }

    private void addSingleTableData(Map<String, List<Object>> dataMap, Collection<SingleTableRule> rules) {
        Optional<Integer> count = rules.stream().map(each -> (Collection)((Object)each.export("single_tables").orElse(Collections.emptyMap()))).map(Collection::size).reduce(Integer::sum);
        dataMap.compute(SINGLE_TABLE, (key, value) -> this.buildRow((Collection<Object>)value, SINGLE_TABLE, count.orElse(0)));
    }

    private boolean hasRuleConfiguration(ShardingSphereDatabase database) {
        Collection configs = database.getRuleMetaData().getConfigurations();
        return null != configs && !configs.isEmpty();
    }

    private void initData(Map<String, List<Object>> dataMap) {
        this.addDefaultData(dataMap, SINGLE_TABLE, SHARDING_TABLE, SHARDING_BINDING_TABLE, SHARDING_BROADCAST_TABLE, SHARDING_SCALING, READWRITE_SPLITTING, DB_DISCOVERY, ENCRYPT, SHADOW);
    }

    private void addConfigurationData(Map<String, List<Object>> dataMap, Collection<RuleConfiguration> ruleConfigs) {
        ruleConfigs.forEach(each -> {
            this.addShardingData(dataMap, (RuleConfiguration)each);
            this.addReadwriteSplittingData(dataMap, (RuleConfiguration)each);
            this.addDBDiscoveryData(dataMap, (RuleConfiguration)each);
            this.addEncryptData(dataMap, (RuleConfiguration)each);
            this.addShadowData(dataMap, (RuleConfiguration)each);
        });
    }

    private void addShardingData(Map<String, List<Object>> dataMap, RuleConfiguration ruleConfig) {
        if (!(ruleConfig instanceof ShardingRuleConfiguration)) {
            return;
        }
        this.addData(dataMap, SHARDING_TABLE, () -> ((ShardingRuleConfiguration)ruleConfig).getTables().size() + ((ShardingRuleConfiguration)ruleConfig).getAutoTables().size());
        this.addData(dataMap, SHARDING_BINDING_TABLE, () -> ((ShardingRuleConfiguration)ruleConfig).getBindingTableGroups().size());
        this.addData(dataMap, SHARDING_BROADCAST_TABLE, () -> ((ShardingRuleConfiguration)ruleConfig).getBroadcastTables().size());
        this.addData(dataMap, SHARDING_SCALING, () -> ((ShardingRuleConfiguration)ruleConfig).getScaling().size());
    }

    private void addReadwriteSplittingData(Map<String, List<Object>> dataMap, RuleConfiguration ruleConfig) {
        if (!(ruleConfig instanceof ReadwriteSplittingRuleConfiguration)) {
            return;
        }
        this.addData(dataMap, READWRITE_SPLITTING, () -> ((ReadwriteSplittingRuleConfiguration)ruleConfig).getDataSources().size());
    }

    private void addDBDiscoveryData(Map<String, List<Object>> dataMap, RuleConfiguration ruleConfig) {
        if (!(ruleConfig instanceof DatabaseDiscoveryRuleConfiguration)) {
            return;
        }
        this.addData(dataMap, DB_DISCOVERY, () -> ((DatabaseDiscoveryRuleConfiguration)ruleConfig).getDataSources().size());
    }

    private void addEncryptData(Map<String, List<Object>> dataMap, RuleConfiguration ruleConfig) {
        if (!(ruleConfig instanceof EncryptRuleConfiguration)) {
            return;
        }
        this.addData(dataMap, ENCRYPT, () -> ((EncryptRuleConfiguration)ruleConfig).getTables().size());
    }

    private void addShadowData(Map<String, List<Object>> dataMap, RuleConfiguration ruleConfig) {
        if (!(ruleConfig instanceof ShadowRuleConfiguration)) {
            return;
        }
        this.addData(dataMap, SHADOW, () -> ((ShadowRuleConfiguration)ruleConfig).getDataSources().size());
    }

    private void addData(Map<String, List<Object>> dataMap, String dataKey, Supplier<Integer> apply) {
        dataMap.compute(dataKey, (key, value) -> this.buildRow((Collection<Object>)value, dataKey, (Integer)apply.get()));
    }

    private void addDefaultData(Map<String, List<Object>> dataMap, String ... dataKey) {
        for (String each : dataKey) {
            dataMap.putIfAbsent(each, this.buildRow(each, 0));
        }
    }

    private List<Object> buildRow(Collection<Object> value, String ruleName, Integer count) {
        if (value == null) {
            return Arrays.asList(ruleName, count);
        }
        Integer oldCount = (Integer)new LinkedList<Object>(value).getLast();
        return Arrays.asList(ruleName, Integer.sum(oldCount, count));
    }

    private List<Object> buildRow(String ruleName, Integer count) {
        return Arrays.asList(ruleName, count);
    }
}

