/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.convert;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;

public final class TrafficRuleConverter {
    public static TrafficRuleConfiguration convert(Collection<TrafficRuleSegment> segments) {
        TrafficRuleConfiguration result = new TrafficRuleConfiguration();
        segments.forEach(each -> TrafficRuleConverter.setConfigurationData(result, each));
        return result;
    }

    private static void setConfigurationData(TrafficRuleConfiguration result, TrafficRuleSegment segment) {
        ShardingSphereAlgorithmConfiguration trafficAlgorithm = TrafficRuleConverter.createAlgorithmConfiguration(segment.getAlgorithm());
        ShardingSphereAlgorithmConfiguration loadBalancer = TrafficRuleConverter.createAlgorithmConfiguration(segment.getLoadBalancer());
        String trafficAlgorithmName = TrafficRuleConverter.createAlgorithmName(segment.getName(), trafficAlgorithm);
        String loadBalancerName = TrafficRuleConverter.createAlgorithmName(segment.getName(), loadBalancer);
        TrafficStrategyConfiguration trafficStrategy = TrafficRuleConverter.createTrafficStrategy(segment, trafficAlgorithmName, loadBalancerName);
        result.getTrafficStrategies().add(trafficStrategy);
        result.getTrafficAlgorithms().put(trafficAlgorithmName, trafficAlgorithm);
        Optional.ofNullable(loadBalancerName).ifPresent(optional -> result.getLoadBalancers().put(loadBalancerName, loadBalancer));
    }

    private static ShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return null == segment ? null : new ShardingSphereAlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private static TrafficStrategyConfiguration createTrafficStrategy(TrafficRuleSegment trafficRuleSegment, String trafficAlgorithmName, String loadBalancerName) {
        return new TrafficStrategyConfiguration(trafficRuleSegment.getName(), trafficRuleSegment.getLabels(), trafficAlgorithmName, loadBalancerName);
    }

    private static String createAlgorithmName(String ruleName, ShardingSphereAlgorithmConfiguration algorithm) {
        return null == algorithm ? null : String.format("%s_%s", ruleName, algorithm.getType()).toLowerCase();
    }
}

