/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.expr.InlineExpressionParser;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.spi.type.typed.TypedSPIRegistry;

public final class ShardingRuleConfigurationImportChecker {
    private static final String SHARDING = "sharding";
    private static final String KEY_GENERATOR = "key generator";
    private static final Map<String, Class<? extends ShardingSphereAlgorithm>> ALGORITHM_TYPE_MAP = new HashMap<String, Class<? extends ShardingSphereAlgorithm>>(2, 1.0f);

    public void check(ShardingSphereDatabase database, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == database || null == currentRuleConfig) {
            return;
        }
        String databaseName = database.getName();
        this.checkLogicTables(databaseName, currentRuleConfig);
        this.checkResources(databaseName, database, currentRuleConfig);
        this.checkKeyGenerators(currentRuleConfig);
        this.checkShardingAlgorithms(currentRuleConfig);
    }

    private void checkLogicTables(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection tablesLogicTables = currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        Collection autoTablesLogicTables = currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        LinkedList allLogicTables = new LinkedList();
        allLogicTables.addAll(tablesLogicTables);
        allLogicTables.addAll(autoTablesLogicTables);
        Set duplicatedLogicTables = allLogicTables.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)duplicatedLogicTables.isEmpty(), () -> new DuplicateRuleException(SHARDING, databaseName, (Collection)duplicatedLogicTables));
    }

    private void checkShardingAlgorithms(ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        this.checkInvalidAlgorithms(SHARDING, currentRuleConfig.getShardingAlgorithms().values());
    }

    private void checkKeyGenerators(ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        this.checkInvalidAlgorithms(KEY_GENERATOR, currentRuleConfig.getKeyGenerators().values());
    }

    private void checkInvalidAlgorithms(String algorithmType, Collection<ShardingSphereAlgorithmConfiguration> algorithmConfigs) throws DistSQLException {
        Collection invalidAlgorithms = algorithmConfigs.stream().filter(each -> !TypedSPIRegistry.findRegisteredService(ALGORITHM_TYPE_MAP.get(algorithmType), (String)each.getType(), (Properties)new Properties()).isPresent()).map(ShardingSphereAlgorithmConfiguration::getType).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException(algorithmType, invalidAlgorithms));
    }

    private Collection<String> getRequiredResources(ShardingRuleConfiguration currentRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        currentRuleConfig.getTables().forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        currentRuleConfig.getAutoTables().forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        List actualDataSources = new InlineExpressionParser(shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return new HashSet<String>(actualDataSources);
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private void checkResources(String databaseName, ShardingSphereDatabase database, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection<String> requiredResource = this.getRequiredResources(currentRuleConfig);
        Collection notExistedResources = database.getResource().getNotExistedResources(requiredResource);
        Collection<String> logicResources = this.getLogicResources(database);
        notExistedResources.removeIf(logicResources::contains);
        DistSQLException.predictionThrow((boolean)notExistedResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistedResources));
    }

    private Collection<String> getLogicResources(ShardingSphereDatabase database) {
        return database.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataSourceContainedRule).map(each -> ((DataSourceContainedRule)each).getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static {
        ALGORITHM_TYPE_MAP.put(SHARDING, ShardingAlgorithm.class);
        ALGORITHM_TYPE_MAP.put(KEY_GENERATOR, KeyGenerateAlgorithm.class);
    }
}

