/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.expr.InlineExpressionParser;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.factory.ReplicaLoadBalanceAlgorithmFactory;

public final class ReadwriteSplittingRuleConfigurationImportChecker {
    public void check(ShardingSphereDatabase database, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == database || null == currentRuleConfig) {
            return;
        }
        String databaseName = database.getName();
        this.checkResources(databaseName, database, currentRuleConfig);
        this.checkLoadBalancers(currentRuleConfig);
    }

    private void checkResources(String databaseName, ShardingSphereDatabase database, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        LinkedHashSet requireResources = new LinkedHashSet();
        LinkedHashSet requireDiscoverableResources = new LinkedHashSet();
        currentRuleConfig.getDataSources().forEach(each -> {
            if (each.getAutoAwareDataSourceName().isPresent()) {
                requireDiscoverableResources.add((String)each.getAutoAwareDataSourceName().get());
            }
            if (each.getWriteDataSourceName().isPresent()) {
                requireResources.add((String)each.getWriteDataSourceName().get());
            }
            if (each.getReadDataSourceNames().isPresent()) {
                requireResources.addAll(new InlineExpressionParser((String)each.getReadDataSourceNames().get()).splitAndEvaluate());
            }
        });
        Collection notExistResources = database.getResource().getNotExistedResources(requireResources);
        DistSQLException.predictionThrow((boolean)notExistResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistResources));
        Collection<String> logicResources = this.getLogicResources(database);
        Collection notExistLogicResources = requireDiscoverableResources.stream().filter(each -> !logicResources.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistLogicResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistLogicResources));
    }

    private Collection<String> getLogicResources(ShardingSphereDatabase database) {
        return database.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataSourceContainedRule).map(each -> ((DataSourceContainedRule)each).getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void checkLoadBalancers(ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection notExistedLoadBalancers = currentRuleConfig.getLoadBalancers().values().stream().map(ShardingSphereAlgorithmConfiguration::getType).filter(each -> !ReplicaLoadBalanceAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedLoadBalancers.isEmpty(), () -> new InvalidAlgorithmConfigurationException("Load balancers", notExistedLoadBalancers));
    }
}

