/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.checker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class DatabaseDiscoveryRuleConfigurationImportChecker {
    private static final String DB_DISCOVERY = "Database discovery";

    public void check(ShardingSphereDatabase database, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == database || null == currentRuleConfig) {
            return;
        }
        String databaseName = database.getName();
        this.checkResources(databaseName, database, currentRuleConfig);
        this.checkDiscoverTypeAndHeartbeat(databaseName, currentRuleConfig);
    }

    private void checkResources(String databaseName, ShardingSphereDatabase database, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        LinkedHashSet requireResources = new LinkedHashSet();
        currentRuleConfig.getDataSources().forEach(each -> requireResources.addAll(each.getDataSourceNames()));
        Collection notExistResources = database.getResource().getNotExistedResources(requireResources);
        DistSQLException.predictionThrow((boolean)notExistResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistResources));
    }

    private void checkDiscoverTypeAndHeartbeat(String databaseName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection invalidInput = currentRuleConfig.getDiscoveryTypes().values().stream().map(ShardingSphereAlgorithmConfiguration::getType).filter(each -> !DatabaseDiscoveryProviderAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidInput.isEmpty(), () -> new InvalidAlgorithmConfigurationException(DB_DISCOVERY.toLowerCase(), invalidInput));
        currentRuleConfig.getDataSources().forEach(each -> {
            if (!currentRuleConfig.getDiscoveryTypes().containsKey(each.getDiscoveryTypeName())) {
                invalidInput.add(each.getDiscoveryTypeName());
            }
            if (!currentRuleConfig.getDiscoveryHeartbeats().containsKey(each.getDiscoveryHeartbeatName())) {
                invalidInput.add(each.getDiscoveryHeartbeatName());
            }
        });
        DistSQLException.predictionThrow((boolean)invalidInput.isEmpty(), () -> new RequiredAlgorithmMissedException(DB_DISCOVERY, databaseName, invalidInput));
    }
}

