/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common;

import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.HintDistSQLStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintStatementExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintStatementExecutorFactory;

public final class HintDistSQLBackendHandler
implements TextProtocolBackendHandler {
    private final HintDistSQLStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private HintStatementExecutor<? extends HintDistSQLStatement> hintStatementExecutor;

    @Override
    public ResponseHeader execute() throws SQLException {
        if (!((Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_HINT_ENABLED)).booleanValue()) {
            throw new UnsupportedOperationException(String.format("%s should be true, please check your config", ConfigurationPropertyKey.PROXY_HINT_ENABLED.getKey()));
        }
        this.hintStatementExecutor = HintStatementExecutorFactory.newInstance(this.sqlStatement, this.connectionSession);
        return this.hintStatementExecutor.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.hintStatementExecutor.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.hintStatementExecutor.getQueryResponseRow().getData();
    }

    @Generated
    public HintDistSQLBackendHandler(HintDistSQLStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }

    @Generated
    public HintDistSQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @Generated
    public HintStatementExecutor<? extends HintDistSQLStatement> getHintStatementExecutor() {
        return this.hintStatementExecutor;
    }
}

