/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.advanced;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.advanced.PreviewStatement;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutorFactory;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementDatabaseHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;

public final class PreviewDistSQLBackendHandler
extends QueryableRALBackendHandler<PreviewStatement, PreviewDistSQLBackendHandler> {
    private static final String DATA_SOURCE_NAME = "data_source_name";
    private static final String ACTUAL_SQL = "actual_sql";
    private ConnectionSession connectionSession;
    private final KernelProcessor kernelProcessor = new KernelProcessor();

    @Override
    public PreviewDistSQLBackendHandler init(RALBackendHandler.HandlerParameter<PreviewStatement> parameter) {
        this.connectionSession = parameter.getConnectionSession();
        return (PreviewDistSQLBackendHandler)super.init(parameter);
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(DATA_SOURCE_NAME, ACTUAL_SQL);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) throws SQLException {
        ShardingSphereDatabase database;
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String databaseName = this.getDatabaseName();
        String databaseType = DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(databaseName)).getProtocolType());
        Optional sqlParserRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        SQLStatement previewedStatement = ((SQLParserRule)sqlParserRule.get()).getSQLParserEngine(databaseType).parse(((PreviewStatement)this.sqlStatement).getSql(), false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaData().getDatabases(), (SQLStatement)previewedStatement, (String)databaseName);
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().ifPresent(SQLStatementDatabaseHolder::set);
        }
        if (!(database = ProxyContext.getInstance().getDatabase(this.connectionSession.getDatabaseName())).isComplete()) {
            throw new RuleNotExistedException();
        }
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, ((PreviewStatement)this.sqlStatement).getSql(), Collections.emptyList());
        ExecutionContext executionContext = this.kernelProcessor.generateExecutionContext(logicSQL, database, metaDataContexts.getMetaData().getProps());
        Collection<ExecutionUnit> executionUnits = executionContext.getRouteContext().isFederated() ? this.getFederationExecutionUnits(logicSQL, databaseName, metaDataContexts) : executionContext.getExecutionUnits();
        return executionUnits.stream().map(this::buildRow).collect(Collectors.toList());
    }

    private List<Object> buildRow(ExecutionUnit unit) {
        return Arrays.asList(unit.getDataSourceName(), unit.getSqlUnit().getSql());
    }

    private Collection<ExecutionUnit> getFederationExecutionUnits(LogicSQL logicSQL, String databaseName, MetaDataContexts metaDataContexts) throws SQLException {
        SQLStatement sqlStatement = logicSQL.getSqlStatementContext().getSqlStatement();
        boolean isReturnGeneratedKeys = sqlStatement instanceof MySQLInsertStatement;
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, metaDataContexts);
        FederationContext context = new FederationContext(true, logicSQL, metaDataContexts.getMetaData().getDatabases());
        DatabaseType databaseType = ((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.getDatabaseName())).getResource().getDatabaseType();
        String schemaName = logicSQL.getSqlStatementContext().getTablesContext().getSchemaName().orElse(DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)databaseName));
        FederationExecutor executor = FederationExecutorFactory.newInstance((String)databaseName, (String)schemaName, (OptimizerContext)metaDataContexts.getOptimizerContext(), (ConfigurationProperties)metaDataContexts.getMetaData().getProps(), (JDBCExecutor)new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), false));
        executor.executeQuery(prepareEngine, this.createPreviewFederationCallback(sqlStatement, databaseType), context);
        return context.getExecutionUnits();
    }

    private JDBCExecutorCallback<ExecuteResult> createPreviewFederationCallback(SQLStatement sqlStatement, DatabaseType databaseType) {
        return new JDBCExecutorCallback<ExecuteResult>(databaseType, sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return new JDBCStreamQueryResult(statement.executeQuery(sql));
            }

            protected Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement) {
                return Optional.empty();
            }
        };
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaDataContexts) {
        int maxConnectionsSizePerQuery = (Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (ExecutorConnectionManager)((JDBCBackendConnection)this.connectionSession.getBackendConnection()), (ExecutorStatementManager)((JDBCBackendStatement)this.connectionSession.getStatementManager()), (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), ((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.getDatabaseName())).getRuleMetaData().getRules());
    }

    private String getDatabaseName() {
        String result;
        String string = result = !Strings.isNullOrEmpty((String)this.connectionSession.getDatabaseName()) ? this.connectionSession.getDatabaseName() : this.connectionSession.getDefaultDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllDatabaseNames().contains(result)) {
            throw new DatabaseNotExistedException(result);
        }
        return result;
    }
}

