/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.advanced;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.advanced.ParseStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ParseDistSQLBackendHandler
extends QueryableRALBackendHandler<ParseStatement, ParseDistSQLBackendHandler> {
    private static final String PARSED_STATEMENT = "parsed_statement";
    private static final String PARSED_STATEMENT_DETAIL = "parsed_statement_detail";
    private DatabaseType databaseType;
    private ConnectionSession connectionSession;

    @Override
    public ParseDistSQLBackendHandler init(RALBackendHandler.HandlerParameter<ParseStatement> parameter) {
        this.databaseType = parameter.getDatabaseType();
        this.connectionSession = parameter.getConnectionSession();
        return (ParseDistSQLBackendHandler)super.init(parameter);
    }

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(PARSED_STATEMENT, PARSED_STATEMENT_DETAIL);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) {
        SQLStatement parsedSqlStatement;
        Optional sqlParserRule = contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        try {
            parsedSqlStatement = ((SQLParserRule)sqlParserRule.get()).getSQLParserEngine(ParseDistSQLBackendHandler.getStorageType(this.databaseType, this.connectionSession).getType()).parse(((ParseStatement)this.sqlStatement).getSql(), false);
        }
        catch (SQLParsingException ex) {
            throw new SQLParsingException("You have a syntax error in your parsed statement");
        }
        return Collections.singleton(Arrays.asList(parsedSqlStatement.getClass().getSimpleName(), new Gson().toJson((Object)parsedSqlStatement)));
    }

    private static DatabaseType getStorageType(DatabaseType defaultDatabaseType, ConnectionSession connectionSession) {
        String databaseName = connectionSession.getDatabaseName();
        return Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().databaseExists(databaseName) ? defaultDatabaseType : ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getResource().getDatabaseType();
    }
}

