/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.advanced;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.shardingsphere.distsql.parser.statement.ral.advanced.FormatStatement;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.api.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.api.SQLVisitorEngine;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class FormatHandler
extends QueryableRALBackendHandler<FormatStatement, FormatHandler> {
    private static final String FORMATTED_RESULT = "formatted_result";

    @Override
    protected Collection<String> getColumnNames() {
        return Collections.singletonList(FORMATTED_RESULT);
    }

    @Override
    protected Collection<List<Object>> getRows(ContextManager contextManager) throws SQLException {
        ParseASTNode parseASTNode;
        CacheOption cacheOption = new CacheOption(128, 1024L);
        SQLParserEngine parserEngine = new SQLParserEngine("MySQL", cacheOption);
        try {
            parseASTNode = parserEngine.parse(((FormatStatement)this.sqlStatement).getSql(), false);
        }
        catch (SQLParsingException ex) {
            throw new SQLParsingException("You have a syntax error in your formatted statement");
        }
        Properties props = new Properties();
        props.setProperty("parameterized", Boolean.FALSE.toString());
        SQLVisitorEngine visitorEngine = new SQLVisitorEngine("MySQL", "FORMAT", false, props);
        return Collections.singleton(Collections.singletonList(visitorEngine.visit(parseASTNode)));
    }
}

