/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;

public abstract class RALBackendHandler<E extends RALStatement, R extends RALBackendHandler>
implements TextProtocolBackendHandler {
    protected E sqlStatement;

    @Override
    public final ResponseHeader execute() throws SQLException {
        Preconditions.checkArgument((null != this.sqlStatement ? 1 : 0) != 0, (Object)"sql statement cannot be empty.");
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        return this.handle(contextManager, this.sqlStatement);
    }

    protected abstract ResponseHeader handle(ContextManager var1, E var2) throws SQLException;

    public R init(HandlerParameter<E> parameter) {
        this.initStatement(parameter.getStatement());
        return (R)this;
    }

    public final R initStatement(E statement) {
        this.sqlStatement = statement;
        return (R)this;
    }

    public static class HandlerParameter<E extends RALStatement> {
        private final E statement;
        private final DatabaseType databaseType;
        private final ConnectionSession connectionSession;

        @Generated
        public E getStatement() {
            return this.statement;
        }

        @Generated
        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        @Generated
        public ConnectionSession getConnectionSession() {
            return this.connectionSession;
        }

        @Generated
        public HandlerParameter(E statement, DatabaseType databaseType, ConnectionSession connectionSession) {
            this.statement = statement;
            this.databaseType = databaseType;
            this.connectionSession = connectionSession;
        }
    }
}

