/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.TextQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;

public abstract class QueryableRALBackendHandler<E extends RALStatement, R extends QueryableRALBackendHandler>
extends RALBackendHandler<E, R> {
    private List<QueryHeader> queryHeaders;
    private MultipleLocalDataMergedResult mergedResult;

    @Override
    protected final ResponseHeader handle(ContextManager contextManager, E sqlStatement) throws SQLException {
        this.queryHeaders = this.createQueryHeader(this.getColumnNames());
        this.mergedResult = this.createMergedResult(this.getRows(contextManager));
        return new QueryResponseHeader(this.queryHeaders);
    }

    @Override
    public final boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public final Collection<Object> getRowData() throws SQLException {
        return this.createQueryResponseRow(this.queryHeaders.size(), this.mergedResult).getData();
    }

    protected abstract Collection<String> getColumnNames();

    protected abstract Collection<List<Object>> getRows(ContextManager var1) throws SQLException;

    private MultipleLocalDataMergedResult createMergedResult(Collection<List<Object>> rows) {
        return new MultipleLocalDataMergedResult(rows);
    }

    private List<QueryHeader> createQueryHeader(Collection<String> columnNames) {
        return columnNames.stream().map(each -> new QueryHeader("", "", (String)each, (String)each, 1, "CHAR", 255, 0, false, false, false, false)).collect(Collectors.toList());
    }

    private QueryResponseRow createQueryResponseRow(int size, MultipleLocalDataMergedResult mergedResult) {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(size);
        for (int i = 0; i < size; ++i) {
            cells.add(new TextQueryResponseCell(mergedResult.getValue(i + 1, Object.class)));
        }
        return new QueryResponseRow(cells);
    }
}

