/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.CommonDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.QueryableRALStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.scaling.QueryableScalingRALStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.scaling.UpdatableScalingRALStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseLockedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.RALBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.RDLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.distsql.rql.RQLBackendHandlerFactory;

public final class DistSQLBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(DatabaseType databaseType, DistSQLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        if (sqlStatement instanceof RQLStatement) {
            return RQLBackendHandlerFactory.newInstance((RQLStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RDLStatement) {
            DistSQLBackendHandlerFactory.checkLockedDatabase(connectionSession);
            return RDLBackendHandlerFactory.newInstance((RDLStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RALStatement) {
            if (sqlStatement instanceof CommonDistSQLStatement || sqlStatement instanceof QueryableRALStatement || sqlStatement instanceof QueryableScalingRALStatement || sqlStatement instanceof UpdatableScalingRALStatement) {
                return RALBackendHandlerFactory.newInstance(databaseType, (RALStatement)sqlStatement, connectionSession);
            }
            DistSQLBackendHandlerFactory.checkLockedDatabase(connectionSession);
            return RALBackendHandlerFactory.newInstance(databaseType, (RALStatement)sqlStatement, connectionSession);
        }
        throw new UnsupportedOperationException(sqlStatement.getClass().getCanonicalName());
    }

    private static void checkLockedDatabase(ConnectionSession connectionSession) {
        String databaseName = connectionSession.getDatabaseName();
        if (null == databaseName) {
            return;
        }
        if (ProxyContext.getInstance().getContextManager().getInstanceContext().getLockContext().isLocked(databaseName)) {
            throw new DatabaseLockedException(databaseName);
        }
    }

    @Generated
    private DistSQLBackendHandlerFactory() {
    }
}

