/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.database;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DBDropNotExistsException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;

public final class DropDatabaseBackendHandler
implements TextProtocolBackendHandler {
    private final DropDatabaseStatement sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() {
        this.check(this.sqlStatement, this.connectionSession.getGrantee());
        if (this.isDropCurrentDatabase(this.sqlStatement.getDatabaseName())) {
            this.connectionSession.setCurrentDatabase(null);
        }
        ProxyContext.getInstance().getContextManager().deleteDatabase(this.sqlStatement.getDatabaseName());
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void check(DropDatabaseStatement sqlStatement, Grantee grantee) {
        String databaseName = sqlStatement.getDatabaseName();
        if (!SQLCheckEngine.check((String)databaseName, DropDatabaseBackendHandler.getRules(databaseName), (Grantee)grantee)) {
            throw new UnknownDatabaseException(databaseName);
        }
        if (!sqlStatement.isContainsExistClause() && !ProxyContext.getInstance().getAllDatabaseNames().contains(databaseName)) {
            throw new DBDropNotExistsException(databaseName);
        }
    }

    private boolean isDropCurrentDatabase(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.connectionSession.getDatabaseName()) && this.connectionSession.getDatabaseName().equals(databaseName);
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        ShardingSphereDatabase database = (ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName);
        if (null != database && null != database.getRuleMetaData()) {
            result.addAll(database.getRuleMetaData().getRules());
        }
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    public DropDatabaseBackendHandler(DropDatabaseStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }
}

