/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.database;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.database.CreateDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.database.DropDatabaseBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;

public final class DatabaseOperateBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(SQLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        return DatabaseOperateBackendHandlerFactory.createBackendHandler(sqlStatement, connectionSession);
    }

    private static TextProtocolBackendHandler createBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof CreateDatabaseStatement) {
            return new CreateDatabaseBackendHandler((CreateDatabaseStatement)sqlStatement);
        }
        if (sqlStatement instanceof DropDatabaseStatement) {
            return new DropDatabaseBackendHandler((DropDatabaseStatement)sqlStatement, connectionSession);
        }
        throw new UnsupportedOperationException(sqlStatement.getClass().getCanonicalName());
    }

    @Generated
    private DatabaseOperateBackendHandlerFactory() {
    }
}

