/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.database;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DBCreateExistsException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;

public final class CreateDatabaseBackendHandler
implements TextProtocolBackendHandler {
    private final CreateDatabaseStatement sqlStatement;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.check(this.sqlStatement);
        ProxyContext.getInstance().getContextManager().addDatabase(this.sqlStatement.getDatabaseName());
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void check(CreateDatabaseStatement sqlStatement) {
        if (!sqlStatement.isContainsNotExistClause() && ProxyContext.getInstance().getAllDatabaseNames().contains(sqlStatement.getDatabaseName())) {
            throw new DBCreateExistsException(sqlStatement.getDatabaseName());
        }
    }

    @Generated
    public CreateDatabaseBackendHandler(CreateDatabaseStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }
}

