/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class UnicastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final ConnectionSession connectionSession;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    @Override
    public Future<ResponseHeader> executeFuture() {
        String databaseName;
        String originDatabase = this.connectionSession.getDatabaseName();
        String string = databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        if (!ProxyContext.getInstance().getDatabase(databaseName).hasDataSource()) {
            throw new RuleNotExistedException();
        }
        this.connectionSession.setCurrentDatabase(databaseName);
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.connectionSession.getBackendConnection());
        return ((Future)this.databaseCommunicationEngine.execute()).eventually(unused -> {
            this.connectionSession.setCurrentDatabase(databaseName);
            return Future.succeededFuture();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        String databaseName;
        String originDatabase = this.connectionSession.getDefaultDatabaseName();
        String string = databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        if (!ProxyContext.getInstance().getDatabase(databaseName).hasDataSource()) {
            throw new RuleNotExistedException();
        }
        try {
            this.connectionSession.setCurrentDatabase(databaseName);
            this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.connectionSession.getBackendConnection());
            ResponseHeader responseHeader = (ResponseHeader)this.databaseCommunicationEngine.execute();
            return responseHeader;
        }
        finally {
            this.connectionSession.setCurrentDatabase(databaseName);
        }
    }

    private String getFirstDatabaseName() {
        Collection<String> databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<String> result = databaseNames.stream().filter(each -> ProxyContext.getInstance().getDatabase((String)each).hasDataSource()).findFirst();
        if (!result.isPresent()) {
            throw new RuleNotExistedException();
        }
        return result.get();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryResponseRow().getData();
    }

    @Override
    public void close() throws SQLException {
        if (this.databaseCommunicationEngine instanceof JDBCDatabaseCommunicationEngine) {
            ((JDBCDatabaseCommunicationEngine)this.databaseCommunicationEngine).close();
        }
    }

    @Generated
    public UnicastDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.connectionSession = connectionSession;
    }
}

