/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import com.google.common.base.Preconditions;
import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.aware.CursorDefinitionAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtil;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class SchemaAssignedDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final ConnectionSession connectionSession;
    private DatabaseCommunicationEngine<?> databaseCommunicationEngine;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.prepareDatabaseCommunicationEngine();
        return (ResponseHeader)this.databaseCommunicationEngine.execute();
    }

    @Override
    public Future<ResponseHeader> executeFuture() {
        try {
            this.prepareDatabaseCommunicationEngine();
            return (Future)this.databaseCommunicationEngine.execute();
        }
        catch (Exception ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    private void prepareDatabaseCommunicationEngine() throws RequiredResourceMissedException {
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(this.connectionSession.getDatabaseName());
        boolean isSystemSchema = SystemSchemaUtil.containsSystemSchema((DatabaseType)this.sqlStatementContext.getDatabaseType(), (Collection)this.sqlStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database);
        if (!isSystemSchema && !database.hasDataSource()) {
            throw new RequiredResourceMissedException(this.connectionSession.getDatabaseName());
        }
        if (!isSystemSchema && !database.isComplete()) {
            throw new RuleNotExistedException();
        }
        if (this.sqlStatementContext instanceof CursorAvailable) {
            this.prepareCursorStatementContext((CursorAvailable)this.sqlStatementContext, this.connectionSession);
        }
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.connectionSession.getBackendConnection());
    }

    private void prepareCursorStatementContext(CursorAvailable statementContext, ConnectionSession connectionSession) {
        String cursorName = statementContext.getCursorName().getIdentifier().getValue().toLowerCase();
        if (statementContext instanceof CursorStatementContext) {
            connectionSession.getCursorDefinitions().put(cursorName, (CursorStatementContext)statementContext);
        }
        if (statementContext instanceof CursorDefinitionAware) {
            CursorStatementContext cursorStatementContext = connectionSession.getCursorDefinitions().get(cursorName);
            Preconditions.checkArgument((null != cursorStatementContext ? 1 : 0) != 0, (String)"Cursor %s does not exist.", (Object)cursorName);
            ((CursorDefinitionAware)statementContext).setUpCursorDefinition(cursorStatementContext);
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryResponseRow().getData();
    }

    @Override
    public void close() throws SQLException {
        if (this.databaseCommunicationEngine instanceof JDBCDatabaseCommunicationEngine) {
            ((JDBCDatabaseCommunicationEngine)this.databaseCommunicationEngine).close();
        }
    }

    @Generated
    public SchemaAssignedDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.connectionSession = connectionSession;
    }
}

