/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.ResourceNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class BroadcastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final ConnectionSession connectionSession;

    @Override
    public Future<ResponseHeader> executeFuture() {
        List<String> databaseNames = this.getDatabaseNamesWithDataSource().orElseThrow(ResourceNotExistedException::new);
        String originalDatabase = this.connectionSession.getDatabaseName();
        ArrayList<Future<ResponseHeader>> futures = new ArrayList<Future<ResponseHeader>>(databaseNames.size());
        for (String each : databaseNames) {
            this.connectionSession.setCurrentDatabase(each);
            futures.add(((VertxDatabaseCommunicationEngine)this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.connectionSession.getBackendConnection())).execute());
        }
        return CompositeFuture.all(futures).compose(unused -> Future.succeededFuture((Object)new UpdateResponseHeader(this.sqlStatementContext.getSqlStatement()))).eventually(unused -> {
            this.connectionSession.setCurrentDatabase(originalDatabase);
            return Future.succeededFuture();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        List<String> databaseNames = this.getDatabaseNamesWithDataSource().orElseThrow(ResourceNotExistedException::new);
        String originalDatabase = this.connectionSession.getDatabaseName();
        try {
            for (String each : databaseNames) {
                this.connectionSession.setCurrentDatabase(each);
                ((DatabaseCommunicationEngine)this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.connectionSession.getBackendConnection())).execute();
            }
        }
        finally {
            this.connectionSession.setCurrentDatabase(originalDatabase);
        }
        return new UpdateResponseHeader(this.sqlStatementContext.getSqlStatement());
    }

    private Optional<List<String>> getDatabaseNamesWithDataSource() {
        List result = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> ProxyContext.getInstance().getDatabase((String)each).hasDataSource()).collect(Collectors.toList());
        return Optional.of(result).filter(each -> !each.isEmpty());
    }

    @Generated
    public BroadcastDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.connectionSession = connectionSession;
    }
}

