/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.BroadcastDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.SchemaAssignedDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.UnicastDatabaseBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class DatabaseBackendHandlerFactory {
    public static DatabaseBackendHandler newInstance(SQLStatementContext<?> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SetStatement || sqlStatement instanceof DCLStatement) {
            return new BroadcastDatabaseBackendHandler(sqlStatementContext, sql, connectionSession);
        }
        if (sqlStatement instanceof DALStatement || sqlStatement instanceof SelectStatement && null == ((SelectStatement)sqlStatement).getFrom()) {
            return new UnicastDatabaseBackendHandler(sqlStatementContext, sql, connectionSession);
        }
        return new SchemaAssignedDatabaseBackendHandler(sqlStatementContext, sql, connectionSession);
    }

    @Generated
    private DatabaseBackendHandlerFactory() {
    }
}

