/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.postgresql.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.AbstractDatabaseMetadataExecutor;

public final class SelectTableExecutor
extends AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor {
    private static final String REL_NAME = "relname";
    private static final String REF_NAME = "refname";
    private static final String TABLE_NAME = "tablename";
    private static final String NAME = "name";
    private String actualTableName = "";
    private List<String> tableNames;

    public SelectTableExecutor(String sql) {
        super(sql);
    }

    @Override
    protected void initDatabaseData(String databaseName) {
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(databaseName);
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)database.getResource().getDatabaseType(), (String)databaseName);
        this.tableNames = new ArrayList<String>(((ShardingSphereSchema)database.getSchemas().get(schemaName)).getAllTableNames());
    }

    @Override
    protected List<String> getDatabaseNames(ConnectionSession connectionSession) {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> SelectTableExecutor.hasAuthority(each, connectionSession.getGrantee())).collect(Collectors.toList());
        return databaseNames.stream().filter(x$0 -> AbstractDatabaseMetadataExecutor.hasDatasource(x$0)).collect(Collectors.toList());
    }

    @Override
    protected void rowPostProcessing(String databaseName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        if (this.actualTableName.isEmpty()) {
            this.actualTableName = aliasMap.getOrDefault(REL_NAME, aliasMap.getOrDefault(TABLE_NAME, aliasMap.getOrDefault(NAME, aliasMap.getOrDefault(REF_NAME, ""))));
        }
    }

    @Override
    protected void createPreProcessing() {
        if (this.actualTableName.isEmpty()) {
            return;
        }
        if (this.tableNames.size() > this.getRows().size()) {
            return;
        }
        LinkedList subList = new LinkedList(this.getRows().subList(0, this.tableNames.size()));
        for (int i = 0; i < subList.size(); ++i) {
            ((Map)subList.get(i)).replace(this.actualTableName, this.tableNames.get(i));
        }
        this.getRows().clear();
        this.getRows().addAll(subList);
    }
}

