/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.postgresql.executor;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Locale;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseSetCharsetExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.postgresql.PostgreSQLCharacterSets;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;

public final class PostgreSQLSetCharsetExecutor
implements DatabaseSetCharsetExecutor {
    private final SetStatement setStatement;
    private String currentValue;

    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        VariableAssignSegment segment = (VariableAssignSegment)this.setStatement.getVariableAssigns().iterator().next();
        String value = this.formatValue(segment.getAssignValue().trim());
        Charset charset = this.parseCharset(value);
        this.currentValue = value;
        connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)charset);
    }

    private String formatValue(String value) {
        return value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1).trim() : value;
    }

    private Charset parseCharset(String value) {
        String result = value.toLowerCase(Locale.ROOT);
        return "default".equals(result) ? StandardCharsets.UTF_8 : PostgreSQLCharacterSets.findCharacterSet(result);
    }

    @Override
    public String getCurrentCharset() {
        return this.currentValue;
    }

    @Generated
    public PostgreSQLSetCharsetExecutor(SetStatement setStatement) {
        this.setStatement = setStatement;
    }
}

