/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.postgresql;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public enum PostgreSQLCharacterSets {
    SQL_ASCII(() -> StandardCharsets.US_ASCII, new String[0]),
    EUC_JP(() -> Charset.forName("EUC_JP"), new String[0]),
    EUC_CN(() -> Charset.forName("EUC_CN"), new String[0]),
    EUC_KR(() -> Charset.forName("EUC_KR"), new String[0]),
    EUC_TW(() -> Charset.forName("EUC_TW"), new String[0]),
    EUC_JIS_2004(() -> Charset.forName("EUC_JIS_2004"), new String[0]),
    UTF8(() -> StandardCharsets.UTF_8, "Unicode"),
    MULE_INTERNAL(() -> Charset.forName("MULE_INTERNAL"), new String[0]),
    LATIN1(() -> StandardCharsets.ISO_8859_1, "ISO88591"),
    LATIN2(() -> Charset.forName("LATIN2"), "ISO88592"),
    LATIN3(() -> Charset.forName("LATIN3"), "ISO88593"),
    LATIN4(() -> Charset.forName("LATIN4"), "ISO88594"),
    LATIN5(() -> Charset.forName("LATIN5"), "ISO88599"),
    LATIN6(() -> Charset.forName("ISO-8859-10"), "ISO885910"),
    LATIN7(() -> Charset.forName("ISO-8859-13"), "ISO885913"),
    LATIN8(() -> Charset.forName("ISO-8859-14"), "ISO885914"),
    LATIN9(() -> Charset.forName("LATIN9"), "ISO885915"),
    LATIN10(() -> Charset.forName("LATIN10"), "ISO885916"),
    WIN1256(() -> Charset.forName("WINDOWS-1256"), new String[0]),
    WIN1258(() -> Charset.forName("WINDOWS-1258"), "ABC", "TCVN", "TCVN5712", "VSCII"),
    WIN866(() -> Charset.forName("WINDOWS-866"), "ALT"),
    WIN874(() -> Charset.forName("WINDOWS-874"), new String[0]),
    KOI8R(() -> Charset.forName("KOI8-R"), new String[0]),
    WIN1251(() -> Charset.forName("WINDOWS-1251"), "WIN"),
    WIN1252(() -> Charset.forName("WINDOWS-1252"), new String[0]),
    ISO_8859_5(() -> Charset.forName("ISO-8859-5"), new String[0]),
    ISO_8859_6(() -> Charset.forName("ISO-8859-6"), new String[0]),
    ISO_8859_7(() -> Charset.forName("ISO-8859-7"), new String[0]),
    ISO_8859_8(() -> Charset.forName("ISO-8859-8"), new String[0]),
    WIN1250(() -> Charset.forName("WINDOWS-1250"), new String[0]),
    WIN1253(() -> Charset.forName("WINDOWS-1253"), new String[0]),
    WIN1254(() -> Charset.forName("WINDOWS-1254"), new String[0]),
    WIN1255(() -> Charset.forName("WINDOWS-1255"), new String[0]),
    WIN1257(() -> Charset.forName("WINDOWS-1257"), new String[0]),
    KOI8U(() -> Charset.forName("KOI8-U"), "KOI8"),
    SJIS(() -> Charset.forName("SJIS"), "Mskanji", "ShiftJIS", "WIN932", "Windows932"),
    BIG5(() -> Charset.forName("BIG5"), "WIN950", "Windows950"),
    GBK(() -> Charset.forName("GBK"), "WIN936", "Windows936"),
    UHC(() -> Charset.forName("UHC"), "WIN949", "Windows949"),
    GB18030(() -> Charset.forName("GB18030"), new String[0]),
    JOHAB(() -> Charset.forName("JOHAB"), new String[0]),
    SHIFT_JIS_2004(() -> Charset.forName("SHIFT_JIS"), new String[0]);

    private static final Map<String, PostgreSQLCharacterSets> CHARACTER_SETS_MAP;
    private final Charset charset;
    private final String[] aliases;

    private PostgreSQLCharacterSets(Supplier<Charset> charsetSupplier, String ... aliases) {
        Charset result = null;
        try {
            result = charsetSupplier.get();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        this.charset = result;
        this.aliases = aliases;
    }

    public static Charset findCharacterSet(String charsetName) {
        PostgreSQLCharacterSets result = CHARACTER_SETS_MAP.get(charsetName.toUpperCase());
        return null != result && null != result.charset ? result.charset : Charset.forName(charsetName);
    }

    static {
        HashMap<String, PostgreSQLCharacterSets> map = new HashMap<String, PostgreSQLCharacterSets>(128);
        for (PostgreSQLCharacterSets each : PostgreSQLCharacterSets.values()) {
            map.put(each.name(), each);
            for (String eachAlias : each.aliases) {
                map.put(eachAlias.toUpperCase(), each);
            }
        }
        CHARACTER_SETS_MAP = map;
    }
}

