/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.postgresql;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.AbstractDatabaseMetadataExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.text.admin.postgresql.executor.PostgreSQLSetCharsetExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.postgresql.executor.SelectDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.postgresql.executor.SelectTableExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class PostgreSQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String PG_TABLESPACE = "pg_tablespace";
    private static final String PG_DATABASE = "pg_database";
    private static final String PG_TRIGGER = "pg_trigger";
    private static final String PG_INHERITS = "pg_inherits";
    private static final String PG_CLASS = "pg_class";
    private static final String PG_PREFIX = "pg_";

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        return Optional.empty();
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SelectStatement) {
            Collection<String> selectedTableNames = this.getSelectedTableNames((SelectStatement)sqlStatement);
            if (selectedTableNames.contains(PG_DATABASE)) {
                return Optional.of(new SelectDatabaseExecutor((SelectStatement)sqlStatement, sql));
            }
            if (this.isQueryPgTable(selectedTableNames)) {
                return Optional.of(new SelectTableExecutor(sql));
            }
            if (selectedTableNames.stream().anyMatch(each -> each.startsWith(PG_PREFIX))) {
                return Optional.of(new AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor(sql));
            }
        }
        if (sqlStatement instanceof SetStatement) {
            SetStatement setStatement = (SetStatement)sqlStatement;
            switch (this.getSetConfigurationParameter(setStatement)) {
                case "client_encoding": {
                    return Optional.of(new PostgreSQLSetCharsetExecutor(setStatement));
                }
                case "extra_float_digits": 
                case "application_name": {
                    return Optional.of(connectionSession -> {});
                }
            }
        }
        return Optional.empty();
    }

    private boolean isQueryPgTable(Collection<String> selectedTableNames) {
        boolean isComplexQueryTable = selectedTableNames.contains(PG_CLASS) && selectedTableNames.contains(PG_TRIGGER) && selectedTableNames.contains(PG_INHERITS);
        return selectedTableNames.contains(PG_TABLESPACE) || isComplexQueryTable;
    }

    private Collection<String> getSelectedTableNames(SelectStatement sqlStatement) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(sqlStatement);
        List subQueryTableSegment = extractor.getTableContext().stream().filter(each -> each instanceof SubqueryTableSegment).map(each -> {
            TableExtractor subExtractor = new TableExtractor();
            subExtractor.extractTablesFromSelect(((SubqueryTableSegment)each).getSubquery().getSelect());
            return subExtractor.getTableContext();
        }).flatMap(Collection::stream).collect(Collectors.toList());
        extractor.getTableContext().addAll(subQueryTableSegment);
        return extractor.getTableContext().stream().filter(each -> each instanceof SimpleTableSegment).map(each -> ((SimpleTableSegment)each).getTableName().getIdentifier().getValue()).collect(Collectors.toList());
    }

    private String getSetConfigurationParameter(SetStatement setStatement) {
        Iterator iterator = setStatement.getVariableAssigns().iterator();
        return iterator.hasNext() ? ((VariableAssignSegment)iterator.next()).getVariable().getVariable().toLowerCase() : "";
    }

    public String getType() {
        return "PostgreSQL";
    }
}

