/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.opengauss;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.opengauss.schema.OgCatalog;
import org.apache.shardingsphere.proxy.backend.text.admin.opengauss.schema.OgDatabase;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class OpenGaussSelectDatabaseExecutor
implements DatabaseAdminQueryExecutor {
    private static final String PG_CATALOG = "pg_catalog";
    private static final String DAT_COMPATIBILITY = "PG";
    private final String sql;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public OpenGaussSelectDatabaseExecutor(String sql) {
        this.sql = SQLUtil.trimSemicolon((String)sql);
    }

    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        try (CalciteConnection connection = DriverManager.getConnection("jdbc:calcite:caseSensitive=false").unwrap(CalciteConnection.class);){
            connection.getRootSchema().add(PG_CATALOG, (Schema)new ReflectiveSchema((Object)this.constructOgCatalog()));
            connection.setSchema(PG_CATALOG);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(this.sql);){
                this.queryResultMetaData = new JDBCQueryResultMetaData(resultSet.getMetaData());
                this.mergedResult = new IteratorStreamMergedResult(Collections.singletonList(new JDBCMemoryQueryResult(resultSet, connectionSession.getDatabaseType())));
            }
        }
    }

    private OgCatalog constructOgCatalog() {
        Collection<String> allDatabaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        OgDatabase[] ogDatabases = new OgDatabase[allDatabaseNames.size()];
        int i = 0;
        for (String each : allDatabaseNames) {
            ogDatabases[i++] = new OgDatabase(each, DAT_COMPATIBILITY);
        }
        return new OgCatalog(ogDatabases);
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

