/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.opengauss;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.text.admin.opengauss.OpenGaussSelectDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.postgresql.PostgreSQLAdminExecutorCreator;

public final class OpenGaussAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String OG_DATABASE = "pg_database";
    private final PostgreSQLAdminExecutorCreator delegated = new PostgreSQLAdminExecutorCreator();

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        return this.delegated.create(sqlStatementContext);
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        if (sqlStatementContext.getTablesContext().getTableNames().contains(OG_DATABASE)) {
            return Optional.of(new OpenGaussSelectDatabaseExecutor(sql));
        }
        return this.delegated.create(sqlStatementContext, sql, databaseName);
    }

    public String getType() {
        return "openGauss";
    }
}

