/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.AbstractDatabaseMetadataExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SelectInformationSchemataExecutor
extends AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor {
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String DEFAULT_CHARACTER_SET_NAME = "DEFAULT_CHARACTER_SET_NAME";
    public static final String DEFAULT_COLLATION_NAME = "DEFAULT_COLLATION_NAME";
    public static final String CATALOG_NAME = "CATALOG_NAME";
    public static final String SQL_PATH = "SQL_PATH";
    public static final String DEFAULT_ENCRYPTION = "DEFAULT_ENCRYPTION";
    private static final Set<String> SCHEMA_WITHOUT_DATA_SOURCE = new LinkedHashSet<String>();
    private final SelectStatement sqlStatement;
    private String schemaNameAlias = "SCHEMA_NAME";
    private boolean queryDatabase;

    public SelectInformationSchemataExecutor(SelectStatement sqlStatement, String sql) {
        super(sql);
        this.sqlStatement = sqlStatement;
    }

    @Override
    protected void createPreProcessing() {
        this.removeDuplicatedRow();
    }

    private void removeDuplicatedRow() {
        if (this.queryDatabase) {
            List<Map> reservedRow = this.getRows().stream().collect(Collectors.groupingBy(each -> each.get(this.schemaNameAlias), Collectors.toCollection(LinkedList::new))).values().stream().map(LinkedList::getFirst).collect(Collectors.toList());
            reservedRow.forEach(each -> this.getRows().removeIf(row -> !this.getRows().contains(each)));
        }
    }

    @Override
    protected List<String> getDatabaseNames(ConnectionSession connectionSession) {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> SelectInformationSchemataExecutor.hasAuthority(each, connectionSession.getGrantee())).collect(Collectors.toList());
        SCHEMA_WITHOUT_DATA_SOURCE.addAll(databaseNames.stream().filter(each -> AbstractDatabaseMetadataExecutor.hasDatasource(each) == false).collect(Collectors.toSet()));
        List<String> result = databaseNames.stream().filter(x$0 -> AbstractDatabaseMetadataExecutor.hasDatasource(x$0)).collect(Collectors.toList());
        if (!SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            this.fillSchemasWithoutDatasource();
        }
        return result;
    }

    @Override
    protected void rowPostProcessing(String databaseName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        ShardingSphereResource resource = ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getResource();
        Set catalogs = resource.getDataSources().keySet().stream().map(each -> resource.getDataSourceMetaData(each).getCatalog()).collect(Collectors.toSet());
        this.schemaNameAlias = aliasMap.getOrDefault(SCHEMA_NAME, "");
        String rowValue = rowMap.getOrDefault(this.schemaNameAlias, "").toString();
        boolean bl = this.queryDatabase = !rowValue.isEmpty();
        if (catalogs.contains(rowValue)) {
            rowMap.replace(this.schemaNameAlias, databaseName);
        } else {
            rowMap.clear();
        }
    }

    private void fillSchemasWithoutDatasource() {
        if (SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            return;
        }
        Map<String, String> defaultRowData = this.getTheDefaultRowData();
        SCHEMA_WITHOUT_DATA_SOURCE.forEach(each -> {
            HashMap<String, String> row = new HashMap<String, String>(defaultRowData);
            row.replace(SCHEMA_NAME, (String)each);
            this.getRows().addLast(row);
        });
        SCHEMA_WITHOUT_DATA_SOURCE.clear();
    }

    private Map<String, String> getTheDefaultRowData() {
        Collection projections = this.sqlStatement.getProjections().getProjections();
        Map<String, String> result = projections.stream().anyMatch(each -> each instanceof ShorthandProjectionSegment) ? Stream.of(CATALOG_NAME, SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME, SQL_PATH, DEFAULT_ENCRYPTION).collect(Collectors.toMap(each -> each, each -> "")) : projections.stream().map(each -> ((ColumnProjectionSegment)each).getColumn().getIdentifier()).map(IdentifierValue::getValue).collect(Collectors.toMap(each -> each, each -> ""));
        return result;
    }
}

